/*
 * Decompiled with CFR 0.152.
 */
import com.isbc.smartcard.esmarttoken.api.Pkcs11Wrapper;
import com.isbc.smartcard.esmarttoken.utils.HexUtils;
import javax.smartcardio.CardTerminal;
import org.apache.log4j.Logger;

public class GenerateKeyPair {
    private static Logger logger = Logger.getLogger(GenerateKeyPair.class);
    private static String SCRIPT_NAME = "GenerateKeyPair";

    private GenerateKeyPair() {
    }

    public static void main(String[] object) {
        Object object2 = new GenerateKeyPair();
        GenerateKeyPair$CmdParams generateKeyPair$CmdParams = ((GenerateKeyPair)object2).getNewParams();
        if (((String[])object).length < 2 || !((GenerateKeyPair)object2).parseArgs((String[])object, generateKeyPair$CmdParams)) {
            ((GenerateKeyPair)object2).printUsage();
            return;
        }
        ((GenerateKeyPair)object2).printArgs(generateKeyPair$CmdParams);
        object = new Pkcs11Wrapper();
        object2 = null;
        if (!generateKeyPair$CmdParams.getReader().isEmpty() && (object2 = Utils.getTerminal(generateKeyPair$CmdParams.getReader())) == null) {
            System.err.print("No reader found\n");
            return;
        }
        String string = generateKeyPair$CmdParams.getModule();
        if (string.isEmpty()) {
            string = Utils.getDefaultModuleName();
        }
        long l2 = -1L;
        try {
            String string2 = Utils.getRandomHexString(16);
            if (generateKeyPair$CmdParams.getType().equalsIgnoreCase("RSA")) {
                long l3 = 1024L;
                if (!generateKeyPair$CmdParams.getBits().isEmpty()) {
                    l3 = Long.parseLong(generateKeyPair$CmdParams.getBits());
                }
                l2 = ((Pkcs11Wrapper)object).generateKeyPairWrap((CardTerminal)object2, string, generateKeyPair$CmdParams.getPin().getBytes(), l3, string2, HexUtils.decodeHex(string2));
            } else {
                l2 = ((Pkcs11Wrapper)object).generateGostR3410_2001KeyPairWrap((CardTerminal)object2, string, generateKeyPair$CmdParams.getPin().getBytes(), string2, HexUtils.decodeHex(string2));
            }
        }
        catch (n n2) {
            logger.error("ERROR decoding Key ID", n2);
        }
        if (l2 != 0L) {
            System.err.print("ERROR creating key pair. Return code: " + l2 + "\n\n");
            return;
        }
        System.out.print("New Key Pair was successfully generated\n\n");
    }

    private GenerateKeyPair$CmdParams getNewParams() {
        return new GenerateKeyPair$CmdParams(this);
    }

    private boolean parseArgs(String[] stringArray, GenerateKeyPair$CmdParams generateKeyPair$CmdParams) {
        boolean bl2 = false;
        int n2 = 0;
        for (String string : stringArray) {
            String[] stringArray2 = string.split("=");
            if (stringArray2.length < 2 || stringArray2[1] == null) {
                System.err.print("Parse error for \"" + string + "\"\n");
                break;
            }
            if (string.startsWith("--terminal=")) {
                generateKeyPair$CmdParams.setReader(stringArray2[1]);
                continue;
            }
            if (string.startsWith("--module=")) {
                generateKeyPair$CmdParams.setModule(stringArray2[1]);
                continue;
            }
            if (string.startsWith("--type=")) {
                n2 |= 1;
                generateKeyPair$CmdParams.setType(stringArray2[1]);
                continue;
            }
            if (string.startsWith("--bits=")) {
                generateKeyPair$CmdParams.setBits(stringArray2[1]);
                continue;
            }
            if (!string.startsWith("--pin=")) continue;
            n2 |= 2;
            generateKeyPair$CmdParams.setPin(stringArray2[1]);
        }
        if (n2 == 3) {
            bl2 = true;
        }
        return bl2;
    }

    private void printUsage() {
        String string = "Usage: " + SCRIPT_NAME + " [OPTIONS]\nOptions:\n--pin \t\tUser PIN for smart card or USB token\n--terminal \tReader name. Optional, if not set, the first available reader is used\n--module \tPath to PKCS#11 library. Optional, if not set, the default library path and name is used\n--type \t\tKey type, valud values: RSA or GOST\n--bits \t\tOnly valid for RSA, can be from 512 till 2048 with 256 steps. Default value: 1024\n\n\n" + "Examples: \n" + SCRIPT_NAME + " --pin=12345678 --type=RSA --bits=1024\n" + SCRIPT_NAME + " --pin=12345678 --type=GOST\n\n\n";
        System.out.print(string);
    }

    private void printArgs(GenerateKeyPair$CmdParams object) {
        StringBuilder stringBuilder = new StringBuilder();
        object = "Start generation key pair:\n\tPIN: \t\t********\n\tTerminal: \t" + (((GenerateKeyPair$CmdParams)object).getReader().isEmpty() ? "[first available]" : ((GenerateKeyPair$CmdParams)object).getReader()) + "\n\tModule: \t" + (((GenerateKeyPair$CmdParams)object).getModule().isEmpty() ? "[default]" : ((GenerateKeyPair$CmdParams)object).getModule()) + "\n\tType: \t\t" + ((GenerateKeyPair$CmdParams)object).getType() + "\n";
        stringBuilder.append((String)object);
        System.out.print(stringBuilder);
    }
}

