/*
 * Decompiled with CFR 0.152.
 */
import com.isbc.smartcard.esmarttoken.api.Pkcs11ObjectAttribute;
import com.isbc.smartcard.esmarttoken.api.Pkcs11Wrapper;
import java.util.ArrayList;
import java.util.List;
import javax.smartcardio.CardTerminal;

public class ListObjects {
    private static String SCRIPT_NAME = "ListObjects";

    private ListObjects() {
    }

    public static void main(String[] object) {
        ListObjects listObjects = new ListObjects();
        ListObjects$CmdParams listObjects$CmdParams = listObjects.getNewParams();
        if (((String[])object).length <= 0 || !listObjects.parseArgs((String[])object, listObjects$CmdParams)) {
            listObjects.printUsage();
            return;
        }
        listObjects.printArgs(listObjects$CmdParams);
        object = new Pkcs11Wrapper();
        CardTerminal cardTerminal = null;
        if (!listObjects$CmdParams.getReader().isEmpty() && (cardTerminal = Utils.getTerminal(listObjects$CmdParams.getReader())) == null) {
            System.err.print("No reader found\n");
            return;
        }
        String string = listObjects$CmdParams.getModule();
        if (string.isEmpty()) {
            string = Utils.getDefaultModuleName();
        }
        ArrayList arrayList = new ArrayList();
        long l2 = ((Pkcs11Wrapper)object).listObjectsWrap(cardTerminal, string, listObjects$CmdParams.getPin().getBytes(), arrayList);
        if (l2 != 0L) {
            System.err.print("ERROR list object. Return code: " + l2 + "\n\n");
            return;
        }
        listObjects.printObjects(arrayList);
    }

    private void printObjects(List object) {
        object = object.iterator();
        while (object.hasNext()) {
            Pkcs11ObjectAttribute pkcs11ObjectAttribute = (Pkcs11ObjectAttribute)object.next();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(pkcs11ObjectAttribute.getType());
            if (pkcs11ObjectAttribute.getKeyType() != null) {
                stringBuilder.append("; " + pkcs11ObjectAttribute.getKeyType());
            }
            stringBuilder.append("\n");
            stringBuilder.append("\t label: " + pkcs11ObjectAttribute.getLabel() + "\n");
            stringBuilder.append("\t ID: " + pkcs11ObjectAttribute.getId() + "\n");
            System.out.print(stringBuilder);
        }
    }

    private ListObjects$CmdParams getNewParams() {
        return new ListObjects$CmdParams(this);
    }

    private boolean parseArgs(String[] stringArray, ListObjects$CmdParams listObjects$CmdParams) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (String string : stringArray) {
            String[] stringArray2 = string.split("=");
            if (stringArray2.length < 2 || stringArray2[1] == null) {
                System.err.print("Parse error for \"" + string + "\"\n");
                break;
            }
            if (string.startsWith("--terminal=")) {
                listObjects$CmdParams.setReader(stringArray2[1]);
                continue;
            }
            if (string.startsWith("--module=")) {
                listObjects$CmdParams.setModule(stringArray2[1]);
                continue;
            }
            if (!string.startsWith("--pin=")) continue;
            bl3 |= true;
            listObjects$CmdParams.setPin(stringArray2[1]);
        }
        if (bl3) {
            bl2 = true;
        }
        return bl2;
    }

    private void printUsage() {
        String string = "Usage: " + SCRIPT_NAME + " [OPTIONS]\nOptions:\n--pin \t\tUser PIN for smart card or USB token\n--terminal \tReader name. Optional, if not set, the first available reader is used\n--module \tPath to PKCS#11 library. Optional, if not set, the default library path and name is used\n\n\nExamples: \n" + SCRIPT_NAME + " --pin=12345678\n\n\n";
        System.out.print(string);
    }

    private void printArgs(ListObjects$CmdParams object) {
        StringBuilder stringBuilder = new StringBuilder();
        object = "Start lits objects:\n\tPIN: \t\t********\n\tTerminal: \t" + (((ListObjects$CmdParams)object).getReader().isEmpty() ? "[first available]" : ((ListObjects$CmdParams)object).getReader()) + "\n\tModule: \t" + (((ListObjects$CmdParams)object).getModule().isEmpty() ? "[default]" : ((ListObjects$CmdParams)object).getModule()) + "\n";
        stringBuilder.append((String)object);
        System.out.print(stringBuilder);
    }
}

