/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.helpers.BoundedFIFO;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;

public class AsyncAppender
extends AppenderSkeleton
implements AppenderAttachable {
    public static final int DEFAULT_BUFFER_SIZE = 128;
    BoundedFIFO bf = new BoundedFIFO(128);
    public AppenderAttachableImpl aai = new AppenderAttachableImpl();
    A dispatcher = new A(this.bf, this);
    boolean locationInfo = false;
    boolean interruptedWarningMessage = false;

    public AsyncAppender() {
        this.dispatcher.start();
    }

    public void addAppender(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.aai;
        synchronized (appenderAttachableImpl) {
            this.aai.addAppender(appender);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void append(LoggingEvent loggingEvent) {
        loggingEvent.getNDC();
        loggingEvent.getThreadName();
        loggingEvent.getMDCCopy();
        if (this.locationInfo) {
            loggingEvent.getLocationInformation();
        }
        BoundedFIFO boundedFIFO = this.bf;
        synchronized (boundedFIFO) {
            while (this.bf.isFull()) {
                try {
                    this.bf.wait();
                }
                catch (InterruptedException interruptedException) {
                    if (!this.interruptedWarningMessage) {
                        this.interruptedWarningMessage = true;
                        LogLog.warn("AsyncAppender interrupted.", interruptedException);
                        continue;
                    }
                    LogLog.warn("AsyncAppender interrupted again.");
                }
            }
            this.bf.put(loggingEvent);
            if (this.bf.wasEmpty()) {
                this.bf.notify();
            }
            return;
        }
    }

    public void close() {
        Object object = this;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        object = this.dispatcher;
        BoundedFIFO boundedFIFO = ((A)object).a;
        synchronized (boundedFIFO) {
            ((A)object).a = true;
            if (((A)object).a.length() == 0) {
                ((A)object).a.notify();
            }
        }
        try {
            this.dispatcher.join();
        }
        catch (InterruptedException interruptedException) {
            LogLog.error("Got an InterruptedException while waiting for the dispatcher to finish.", interruptedException);
        }
        this.dispatcher = null;
        this.bf = null;
    }

    public Enumeration getAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.aai;
        synchronized (appenderAttachableImpl) {
            Enumeration enumeration = this.aai.getAllAppenders();
            return enumeration;
        }
    }

    public Appender getAppender(String object) {
        AppenderAttachableImpl appenderAttachableImpl = this.aai;
        synchronized (appenderAttachableImpl) {
            object = this.aai.getAppender((String)object);
            return object;
        }
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public boolean isAttached(Appender appender) {
        return this.aai.isAttached(appender);
    }

    public boolean requiresLayout() {
        return false;
    }

    public void removeAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.aai;
        synchronized (appenderAttachableImpl) {
            this.aai.removeAllAppenders();
            return;
        }
    }

    public void removeAppender(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.aai;
        synchronized (appenderAttachableImpl) {
            this.aai.removeAppender(appender);
            return;
        }
    }

    public void removeAppender(String string) {
        AppenderAttachableImpl appenderAttachableImpl = this.aai;
        synchronized (appenderAttachableImpl) {
            this.aai.removeAppender(string);
            return;
        }
    }

    public void setLocationInfo(boolean bl2) {
        this.locationInfo = bl2;
    }

    public void setBufferSize(int n2) {
        this.bf.resize(n2);
    }

    public int getBufferSize() {
        return this.bf.getMaxSize();
    }
}

