/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.OutputStreamWriter;
import org.apache.log4j.Layout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.helpers.LogLog;

public class ConsoleAppender
extends WriterAppender {
    public static final String SYSTEM_OUT = "System.out";
    public static final String SYSTEM_ERR = "System.err";
    protected String target = "System.out";

    public ConsoleAppender() {
    }

    public ConsoleAppender(Layout layout) {
        this(layout, SYSTEM_OUT);
    }

    public ConsoleAppender(Layout layout, String string) {
        this.layout = layout;
        if (SYSTEM_OUT.equals(string)) {
            this.setWriter(new OutputStreamWriter(System.out));
            return;
        }
        if (SYSTEM_ERR.equalsIgnoreCase(string)) {
            this.setWriter(new OutputStreamWriter(System.err));
            return;
        }
        this.targetWarn(string);
    }

    public void setTarget(String string) {
        String string2 = string.trim();
        if (SYSTEM_OUT.equalsIgnoreCase(string2)) {
            this.target = SYSTEM_OUT;
            return;
        }
        if (SYSTEM_ERR.equalsIgnoreCase(string2)) {
            this.target = SYSTEM_ERR;
            return;
        }
        this.targetWarn(string);
    }

    public String getTarget() {
        return this.target;
    }

    void targetWarn(String string) {
        LogLog.warn("[" + string + "] should be System.out or System.err.");
        LogLog.warn("Using previously set target, System.out by default.");
    }

    public void activateOptions() {
        if (this.target.equals(SYSTEM_OUT)) {
            this.setWriter(new OutputStreamWriter(System.out));
            return;
        }
        this.setWriter(new OutputStreamWriter(System.err));
    }

    protected final void closeWriter() {
    }
}

