/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Priority;

public class Level
extends Priority {
    public static final Level OFF = new Level(Integer.MAX_VALUE, "OFF", 0);
    public static final Level FATAL = new Level(50000, "FATAL", 0);
    public static final Level ERROR = new Level(40000, "ERROR", 3);
    public static final Level WARN = new Level(30000, "WARN", 4);
    public static final Level INFO = new Level(20000, "INFO", 6);
    public static final Level DEBUG = new Level(10000, "DEBUG", 7);
    public static final Level ALL = new Level(Integer.MIN_VALUE, "ALL", 7);

    protected Level(int n2, String string, int n3) {
        super(n2, string, n3);
    }

    public static Level toLevel(String string) {
        return Level.toLevel(string, DEBUG);
    }

    public static Level toLevel(int n2) {
        return Level.toLevel(n2, DEBUG);
    }

    public static Level toLevel(int n2, Level level) {
        switch (n2) {
            case -2147483648: {
                return ALL;
            }
            case 10000: {
                return DEBUG;
            }
            case 20000: {
                return INFO;
            }
            case 30000: {
                return WARN;
            }
            case 40000: {
                return ERROR;
            }
            case 50000: {
                return FATAL;
            }
            case 0x7FFFFFFF: {
                return OFF;
            }
        }
        return level;
    }

    public static Level toLevel(String string, Level level) {
        if (string == null) {
            return level;
        }
        if ((string = string.toUpperCase()).equals("ALL")) {
            return ALL;
        }
        if (string.equals("DEBUG")) {
            return DEBUG;
        }
        if (string.equals("INFO")) {
            return INFO;
        }
        if (string.equals("WARN")) {
            return WARN;
        }
        if (string.equals("ERROR")) {
            return ERROR;
        }
        if (string.equals("FATAL")) {
            return FATAL;
        }
        if (string.equals("OFF")) {
            return OFF;
        }
        return level;
    }
}

