/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.helpers.LogLog;

public class NDC {
    static Hashtable ht = new Hashtable();
    static int pushCounter = 0;
    static final int REAP_THRESHOLD = 5;

    private NDC() {
    }

    public static void clear() {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack != null) {
            stack.setSize(0);
        }
    }

    public static Stack cloneStack() {
        Object v2 = ht.get(Thread.currentThread());
        if (v2 == null) {
            return null;
        }
        return (Stack)((Stack)v2).clone();
    }

    public static void inherit(Stack stack) {
        if (stack != null) {
            ht.put(Thread.currentThread(), stack);
        }
    }

    public static String get() {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack != null && !stack.isEmpty()) {
            return ((B)stack.peek()).a;
        }
        return null;
    }

    public static int getDepth() {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack == null) {
            return 0;
        }
        return stack.size();
    }

    private static void lazyRemove() {
        Thread thread;
        Vector<Thread> vector;
        int n2;
        Hashtable hashtable = ht;
        synchronized (hashtable) {
            if (++pushCounter <= 5) {
                return;
            }
            pushCounter = 0;
            n2 = 0;
            vector = new Vector<Thread>();
            Enumeration enumeration = ht.keys();
            while (enumeration.hasMoreElements() && n2 <= 4) {
                thread = (Thread)enumeration.nextElement();
                if (thread.isAlive()) {
                    ++n2;
                    continue;
                }
                n2 = 0;
                vector.addElement(thread);
            }
        }
        n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            thread = (Thread)vector.elementAt(n3);
            LogLog.debug("Lazy NDC removal for thread [" + thread.getName() + "] (" + ht.size() + ").");
            ht.remove(thread);
            ++n3;
        }
    }

    public static String pop() {
        Object object = Thread.currentThread();
        if ((object = (Stack)ht.get(object)) != null && !((Vector)object).isEmpty()) {
            return ((B)((Stack)object).pop()).b;
        }
        return "";
    }

    public static String peek() {
        Object object = Thread.currentThread();
        if ((object = (Stack)ht.get(object)) != null && !((Vector)object).isEmpty()) {
            return ((B)((Stack)object).peek()).b;
        }
        return "";
    }

    public static void push(String string) {
        Thread thread = Thread.currentThread();
        Stack<B> stack = (Stack<B>)ht.get(thread);
        if (stack == null) {
            B b2 = new B(string, null);
            stack = new Stack<B>();
            ht.put(thread, stack);
            stack.push(b2);
            return;
        }
        if (stack.isEmpty()) {
            B b3 = new B(string, null);
            stack.push(b3);
            return;
        }
        B b4 = (B)stack.peek();
        stack.push(new B(string, b4));
    }

    public static void remove() {
        ht.remove(Thread.currentThread());
        NDC.lazyRemove();
    }

    public static void setMaxDepth(int n2) {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack != null && n2 < stack.size()) {
            stack.setSize(n2);
        }
    }
}

