/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;

public class RollingFileAppender
extends FileAppender {
    protected long maxFileSize = 0xA00000L;
    protected int maxBackupIndex = 1;

    public RollingFileAppender() {
    }

    public RollingFileAppender(Layout layout, String string, boolean bl2) {
        super(layout, string, bl2);
    }

    public RollingFileAppender(Layout layout, String string) {
        super(layout, string);
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public long getMaximumFileSize() {
        return this.maxFileSize;
    }

    public void rollOver() {
        LogLog.debug("rolling over count=" + ((CountingQuietWriter)this.qw).getCount());
        LogLog.debug("maxBackupIndex=" + this.maxBackupIndex);
        if (this.maxBackupIndex > 0) {
            File file;
            File file2 = new File(this.fileName + '.' + this.maxBackupIndex);
            if (file2.exists()) {
                file2.delete();
            }
            int n2 = this.maxBackupIndex - 1;
            while (n2 > 0) {
                file2 = new File(this.fileName + "." + n2);
                if (file2.exists()) {
                    file = new File(this.fileName + '.' + (n2 + 1));
                    LogLog.debug("Renaming file " + file2 + " to " + file);
                    file2.renameTo(file);
                }
                --n2;
            }
            file = new File(this.fileName + ".1");
            this.closeFile();
            file2 = new File(this.fileName);
            LogLog.debug("Renaming file " + file2 + " to " + file);
            file2.renameTo(file);
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
            return;
        }
        catch (IOException iOException) {
            LogLog.error("setFile(" + this.fileName + ", false) call failed.", iOException);
            return;
        }
    }

    public synchronized void setFile(String object, boolean bl2, boolean bl3, int n2) {
        super.setFile((String)object, bl2, this.bufferedIO, this.bufferSize);
        if (bl2) {
            object = new File((String)object);
            ((CountingQuietWriter)this.qw).setCount(((File)object).length());
        }
    }

    public void setMaxBackupIndex(int n2) {
        this.maxBackupIndex = n2;
    }

    public void setMaximumFileSize(long l2) {
        this.maxFileSize = l2;
    }

    public void setMaxFileSize(String string) {
        this.maxFileSize = OptionConverter.toFileSize(string, this.maxFileSize + 1L);
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    protected void subAppend(LoggingEvent loggingEvent) {
        super.subAppend(loggingEvent);
        if (this.fileName != null && ((CountingQuietWriter)this.qw).getCount() >= this.maxFileSize) {
            this.rollOver();
        }
    }
}

