/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Layout;
import org.apache.log4j.helpers.DateLayout;
import org.apache.log4j.spi.LoggingEvent;

public class TTCCLayout
extends DateLayout {
    private boolean threadPrinting = true;
    private boolean categoryPrefixing = true;
    private boolean contextPrinting = true;
    protected final StringBuffer buf = new StringBuffer(256);

    public TTCCLayout() {
        this.setDateFormat("RELATIVE", null);
    }

    public TTCCLayout(String string) {
        this.setDateFormat(string);
    }

    public void setThreadPrinting(boolean bl2) {
        this.threadPrinting = bl2;
    }

    public boolean getThreadPrinting() {
        return this.threadPrinting;
    }

    public void setCategoryPrefixing(boolean bl2) {
        this.categoryPrefixing = bl2;
    }

    public boolean getCategoryPrefixing() {
        return this.categoryPrefixing;
    }

    public void setContextPrinting(boolean bl2) {
        this.contextPrinting = bl2;
    }

    public boolean getContextPrinting() {
        return this.contextPrinting;
    }

    public String format(LoggingEvent loggingEvent) {
        String string;
        this.buf.setLength(0);
        this.dateFormat(this.buf, loggingEvent);
        if (this.threadPrinting) {
            this.buf.append('[');
            this.buf.append(loggingEvent.getThreadName());
            this.buf.append("] ");
        }
        this.buf.append(loggingEvent.getLevel().toString());
        this.buf.append(' ');
        if (this.categoryPrefixing) {
            this.buf.append(loggingEvent.getLoggerName());
            this.buf.append(' ');
        }
        if (this.contextPrinting && (string = loggingEvent.getNDC()) != null) {
            this.buf.append(string);
            this.buf.append(' ');
        }
        this.buf.append("- ");
        this.buf.append(loggingEvent.getRenderedMessage());
        this.buf.append(Layout.LINE_SEP);
        return this.buf.toString();
    }

    public boolean ignoresThrowable() {
        return true;
    }
}

