/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.AbsoluteTimeDateFormat;
import org.apache.log4j.helpers.DateTimeDateFormat;
import org.apache.log4j.helpers.ISO8601DateFormat;
import org.apache.log4j.helpers.RelativeTimeDateFormat;
import org.apache.log4j.spi.LoggingEvent;

public abstract class DateLayout
extends Layout {
    public static final String NULL_DATE_FORMAT = "NULL";
    public static final String RELATIVE_TIME_DATE_FORMAT = "RELATIVE";
    protected FieldPosition pos = new FieldPosition(0);
    public static final String DATE_FORMAT_OPTION = "DateFormat";
    public static final String TIMEZONE_OPTION = "TimeZone";
    private String timeZoneID;
    private String dateFormatOption;
    protected DateFormat dateFormat;
    protected Date date = new Date();

    public String[] getOptionStrings() {
        return new String[]{DATE_FORMAT_OPTION, TIMEZONE_OPTION};
    }

    public void setOption(String string, String string2) {
        if (string.equalsIgnoreCase(DATE_FORMAT_OPTION)) {
            this.dateFormatOption = string2.toUpperCase();
            return;
        }
        if (string.equalsIgnoreCase(TIMEZONE_OPTION)) {
            this.timeZoneID = string2;
        }
    }

    public void setDateFormat(String string) {
        if (string != null) {
            this.dateFormatOption = string;
        }
        this.setDateFormat(this.dateFormatOption, TimeZone.getDefault());
    }

    public String getDateFormat() {
        return this.dateFormatOption;
    }

    public void setTimeZone(String string) {
        this.timeZoneID = string;
    }

    public String getTimeZone() {
        return this.timeZoneID;
    }

    public void activateOptions() {
        this.setDateFormat(this.dateFormatOption);
        if (this.timeZoneID != null && this.dateFormat != null) {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone(this.timeZoneID));
        }
    }

    public void dateFormat(StringBuffer stringBuffer, LoggingEvent loggingEvent) {
        if (this.dateFormat != null) {
            this.date.setTime(loggingEvent.timeStamp);
            this.dateFormat.format(this.date, stringBuffer, this.pos);
            stringBuffer.append(' ');
        }
    }

    public void setDateFormat(DateFormat dateFormat, TimeZone timeZone) {
        this.dateFormat = dateFormat;
        this.dateFormat.setTimeZone(timeZone);
    }

    public void setDateFormat(String string, TimeZone timeZone) {
        if (string == null) {
            this.dateFormat = null;
            return;
        }
        if (string.equalsIgnoreCase(NULL_DATE_FORMAT)) {
            this.dateFormat = null;
            return;
        }
        if (string.equalsIgnoreCase(RELATIVE_TIME_DATE_FORMAT)) {
            this.dateFormat = new RelativeTimeDateFormat();
            return;
        }
        if (string.equalsIgnoreCase("ABSOLUTE")) {
            this.dateFormat = new AbsoluteTimeDateFormat(timeZone);
            return;
        }
        if (string.equalsIgnoreCase("DATE")) {
            this.dateFormat = new DateTimeDateFormat(timeZone);
            return;
        }
        if (string.equalsIgnoreCase("ISO8601")) {
            this.dateFormat = new ISO8601DateFormat(timeZone);
            return;
        }
        this.dateFormat = new SimpleDateFormat(string);
        this.dateFormat.setTimeZone(timeZone);
    }
}

