/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.spi.LoggingEvent;

public abstract class PatternConverter {
    public PatternConverter next;
    int min = -1;
    int max = Integer.MAX_VALUE;
    boolean leftAlign = false;
    static String[] SPACES = new String[]{" ", "  ", "    ", "        ", "                ", "                                "};

    public PatternConverter() {
    }

    public PatternConverter(FormattingInfo formattingInfo) {
        this.min = formattingInfo.min;
        this.max = formattingInfo.max;
        this.leftAlign = formattingInfo.leftAlign;
    }

    public abstract String convert(LoggingEvent var1);

    public void format(StringBuffer stringBuffer, LoggingEvent object) {
        if ((object = this.convert((LoggingEvent)object)) == null) {
            if (this.min > 0) {
                this.spacePad(stringBuffer, this.min);
            }
            return;
        }
        int n2 = ((String)object).length();
        if (n2 > this.max) {
            stringBuffer.append(((String)object).substring(n2 - this.max));
            return;
        }
        if (n2 < this.min) {
            if (this.leftAlign) {
                stringBuffer.append((String)object);
                this.spacePad(stringBuffer, this.min - n2);
                return;
            }
            this.spacePad(stringBuffer, this.min - n2);
            stringBuffer.append((String)object);
            return;
        }
        stringBuffer.append((String)object);
    }

    public void spacePad(StringBuffer stringBuffer, int n2) {
        while (n2 >= 32) {
            stringBuffer.append(SPACES[5]);
            n2 -= 32;
        }
        int n3 = 4;
        while (n3 >= 0) {
            if ((n2 & 1 << n3) != 0) {
                stringBuffer.append(SPACES[n3]);
            }
            --n3;
        }
    }
}

