/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.AbsoluteTimeDateFormat;
import org.apache.log4j.helpers.DateTimeDateFormat;
import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.helpers.ISO8601DateFormat;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.helpers.PatternConverter;

public class PatternParser {
    private static final char ESCAPE_CHAR = '%';
    private static final int LITERAL_STATE = 0;
    private static final int CONVERTER_STATE = 1;
    private static final int MINUS_STATE = 2;
    private static final int DOT_STATE = 3;
    private static final int MIN_STATE = 4;
    private static final int MAX_STATE = 5;
    static final int FULL_LOCATION_CONVERTER = 1000;
    static final int METHOD_LOCATION_CONVERTER = 1001;
    static final int CLASS_LOCATION_CONVERTER = 1002;
    static final int LINE_LOCATION_CONVERTER = 1003;
    static final int FILE_LOCATION_CONVERTER = 1004;
    static final int RELATIVE_TIME_CONVERTER = 2000;
    static final int THREAD_CONVERTER = 2001;
    static final int LEVEL_CONVERTER = 2002;
    static final int NDC_CONVERTER = 2003;
    static final int MESSAGE_CONVERTER = 2004;
    int state;
    protected StringBuffer currentLiteral = new StringBuffer(32);
    protected int patternLength;
    protected int i;
    PatternConverter head;
    PatternConverter tail;
    protected FormattingInfo formattingInfo = new FormattingInfo();
    protected String pattern;
    static Class class$java$text$DateFormat;

    public PatternParser(String string) {
        this.pattern = string;
        this.patternLength = string.length();
        this.state = 0;
    }

    private void addToList(PatternConverter patternConverter) {
        if (this.head == null) {
            this.head = this.tail = patternConverter;
            return;
        }
        this.tail.next = patternConverter;
        this.tail = patternConverter;
    }

    protected String extractOption() {
        int n2;
        if (this.i < this.patternLength && this.pattern.charAt(this.i) == '{' && (n2 = this.pattern.indexOf(125, this.i)) > this.i) {
            String string = this.pattern.substring(this.i + 1, n2);
            this.i = n2 + 1;
            return string;
        }
        return null;
    }

    protected int extractPrecisionOption() {
        String string = this.extractOption();
        int n2 = 0;
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
                if (n2 <= 0) {
                    LogLog.error("Precision option (" + string + ") isn't a positive integer.");
                    n2 = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                LogLog.error("Category option \"" + string + "\" not a decimal integer.", numberFormatException);
            }
        }
        return n2;
    }

    public PatternConverter parse() {
        this.i = 0;
        while (this.i < this.patternLength) {
            char c2 = this.pattern.charAt(this.i++);
            block0 : switch (this.state) {
                case 0: {
                    if (this.i == this.patternLength) {
                        this.currentLiteral.append(c2);
                        break;
                    }
                    if (c2 == '%') {
                        switch (this.pattern.charAt(this.i)) {
                            case '%': {
                                this.currentLiteral.append(c2);
                                ++this.i;
                                break block0;
                            }
                            case 'n': {
                                this.currentLiteral.append(Layout.LINE_SEP);
                                ++this.i;
                                break block0;
                            }
                        }
                        if (this.currentLiteral.length() != 0) {
                            this.addToList(new ac(this.currentLiteral.toString()));
                        }
                        this.currentLiteral.setLength(0);
                        this.currentLiteral.append(c2);
                        this.state = 1;
                        this.formattingInfo.reset();
                        break;
                    }
                    this.currentLiteral.append(c2);
                    break;
                }
                case 1: {
                    this.currentLiteral.append(c2);
                    switch (c2) {
                        case '-': {
                            this.formattingInfo.leftAlign = true;
                            break block0;
                        }
                        case '.': {
                            this.state = 3;
                            break block0;
                        }
                    }
                    if (c2 >= '0' && c2 <= '9') {
                        this.formattingInfo.min = c2 - 48;
                        this.state = 4;
                        break;
                    }
                    this.finalizeConverter(c2);
                    break;
                }
                case 4: {
                    this.currentLiteral.append(c2);
                    if (c2 >= '0' && c2 <= '9') {
                        this.formattingInfo.min = this.formattingInfo.min * 10 + (c2 - 48);
                        break;
                    }
                    if (c2 == '.') {
                        this.state = 3;
                        break;
                    }
                    this.finalizeConverter(c2);
                    break;
                }
                case 3: {
                    this.currentLiteral.append(c2);
                    if (c2 >= '0' && c2 <= '9') {
                        this.formattingInfo.max = c2 - 48;
                        this.state = 5;
                        break;
                    }
                    LogLog.error("Error occured in position " + this.i + ".\n Was expecting digit, instead got char \"" + c2 + "\".");
                    this.state = 0;
                    break;
                }
                case 5: {
                    this.currentLiteral.append(c2);
                    if (c2 >= '0' && c2 <= '9') {
                        this.formattingInfo.max = this.formattingInfo.max * 10 + (c2 - 48);
                        break;
                    }
                    this.finalizeConverter(c2);
                    this.state = 0;
                }
            }
        }
        if (this.currentLiteral.length() != 0) {
            this.addToList(new ac(this.currentLiteral.toString()));
        }
        return this.head;
    }

    protected void finalizeConverter(char c2) {
        Object object;
        switch (c2) {
            case 'c': {
                object = new Z(this.formattingInfo, this.extractPrecisionOption());
                this.currentLiteral.setLength(0);
                break;
            }
            case 'C': {
                object = new aa(this.formattingInfo, this.extractPrecisionOption());
                this.currentLiteral.setLength(0);
                break;
            }
            case 'd': {
                object = "ISO8601";
                Object object2 = this.extractOption();
                if (object2 != null) {
                    object = object2;
                }
                if (((String)object).equalsIgnoreCase("ISO8601")) {
                    object2 = new ISO8601DateFormat();
                } else if (((String)object).equalsIgnoreCase("ABSOLUTE")) {
                    object2 = new AbsoluteTimeDateFormat();
                } else if (((String)object).equalsIgnoreCase("DATE")) {
                    object2 = new DateTimeDateFormat();
                } else {
                    try {
                        object2 = new SimpleDateFormat((String)object);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        LogLog.error("Could not instantiate SimpleDateFormat with " + (String)object, illegalArgumentException);
                        object2 = (DateFormat)OptionConverter.instantiateByClassName("org.apache.log4j.helpers.ISO8601DateFormat", class$java$text$DateFormat == null ? (class$java$text$DateFormat = PatternParser.class$("java.text.DateFormat")) : class$java$text$DateFormat, null);
                    }
                }
                object = new ab(this.formattingInfo, (DateFormat)object2);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'F': {
                object = new ad(this.formattingInfo, 1004);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'l': {
                object = new ad(this.formattingInfo, 1000);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'L': {
                object = new ad(this.formattingInfo, 1003);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'm': {
                object = new Y(this.formattingInfo, 2004);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'M': {
                object = new ad(this.formattingInfo, 1001);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'p': {
                object = new Y(this.formattingInfo, 2002);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'r': {
                object = new Y(this.formattingInfo, 2000);
                this.currentLiteral.setLength(0);
                break;
            }
            case 't': {
                object = new Y(this.formattingInfo, 2001);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'x': {
                object = new Y(this.formattingInfo, 2003);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'X': {
                String string = this.extractOption();
                object = new ae(this.formattingInfo, string);
                this.currentLiteral.setLength(0);
                break;
            }
            default: {
                LogLog.error("Unexpected char [" + c2 + "] at position " + this.i + " in conversion patterrn.");
                object = new ac(this.currentLiteral.toString());
                this.currentLiteral.setLength(0);
            }
        }
        this.addConverter((PatternConverter)object);
    }

    protected void addConverter(PatternConverter patternConverter) {
        this.currentLiteral.setLength(0);
        this.addToList(patternConverter);
        this.state = 0;
        this.formattingInfo.reset();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

