/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.jmx;

import java.util.Enumeration;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.jmx.AbstractDynamicMBean;
import org.apache.log4j.jmx.AppenderDynamicMBean;

public class LoggerDynamicMBean
extends AbstractDynamicMBean
implements NotificationListener {
    private MBeanConstructorInfo[] dConstructors = new MBeanConstructorInfo[1];
    private MBeanOperationInfo[] dOperations = new MBeanOperationInfo[1];
    private Vector dAttributes = new Vector();
    private String dClassName = this.getClass().getName();
    private String dDescription = "This MBean acts as a management facade for a org.apache.log4j.Logger instance.";
    private static Logger cat = Logger.getLogger(class$org$apache$log4j$jmx$LoggerDynamicMBean == null ? (class$org$apache$log4j$jmx$LoggerDynamicMBean = LoggerDynamicMBean.class$("org.apache.log4j.jmx.LoggerDynamicMBean")) : class$org$apache$log4j$jmx$LoggerDynamicMBean);
    private Logger logger;
    static Class class$org$apache$log4j$jmx$LoggerDynamicMBean;
    static Class class$org$apache$log4j$Appender;

    public LoggerDynamicMBean(Logger logger) {
        this.logger = logger;
        this.buildDynamicMBeanInfo();
    }

    public void handleNotification(Notification notification, Object object) {
        cat.debug("Received notification: " + notification.getType());
        this.registerAppenderMBean((Appender)notification.getUserData());
    }

    private void buildDynamicMBeanInfo() {
        Object[] objectArray = this.getClass().getConstructors();
        this.dConstructors[0] = new MBeanConstructorInfo("HierarchyDynamicMBean(): Constructs a HierarchyDynamicMBean instance", objectArray[0]);
        this.dAttributes.add(new MBeanAttributeInfo("name", "java.lang.String", "The name of this Logger.", true, false, false));
        this.dAttributes.add(new MBeanAttributeInfo("priority", "java.lang.String", "The priority of this logger.", true, true, false));
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[2];
        objectArray = mBeanParameterInfoArray;
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("class name", "java.lang.String", "add an appender to this logger");
        objectArray[1] = new MBeanParameterInfo("appender name", "java.lang.String", "name of the appender");
        this.dOperations[0] = new MBeanOperationInfo("addAppender", "addAppender(): add an appender", (MBeanParameterInfo[])objectArray, "void", 1);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[this.dAttributes.size()];
        this.dAttributes.toArray(mBeanAttributeInfoArray);
        return new MBeanInfo(this.dClassName, this.dDescription, mBeanAttributeInfoArray, this.dConstructors, this.dOperations, new MBeanNotificationInfo[0]);
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) {
        if (string.equals("addAppender")) {
            this.addAppender((String)objectArray[0], (String)objectArray[1]);
            return "Hello world.";
        }
        return null;
    }

    public Object getAttribute(String object) {
        if (object == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this.dClassName + " with null attribute name");
        }
        if (((String)object).equals("name")) {
            return this.logger.getName();
        }
        if (((String)object).equals("priority")) {
            object = this.logger.getLevel();
            if (object == null) {
                return null;
            }
            return ((Priority)object).toString();
        }
        if (((String)object).startsWith("appender=")) {
            try {
                return new ObjectName("log4j:" + (String)object);
            }
            catch (Exception exception) {
                cat.error("Could not create ObjectName" + (String)object);
            }
        }
        throw new AttributeNotFoundException("Cannot find " + (String)object + " attribute in " + this.dClassName);
    }

    void addAppender(String object, String string) {
        cat.debug("addAppender called with " + (String)object + ", " + string);
        object = (Appender)OptionConverter.instantiateByClassName((String)object, class$org$apache$log4j$Appender == null ? (class$org$apache$log4j$Appender = LoggerDynamicMBean.class$("org.apache.log4j.Appender")) : class$org$apache$log4j$Appender, null);
        object.setName(string);
        this.logger.addAppender((Appender)object);
    }

    public void setAttribute(Attribute object) {
        if (object == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Cannot invoke a setter of " + this.dClassName + " with null attribute");
        }
        Object object2 = ((Attribute)object).getName();
        object = ((Attribute)object).getValue();
        if (object2 == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke the setter of " + this.dClassName + " with null attribute name");
        }
        if (((String)object2).equals("priority")) {
            if (object instanceof String) {
                object = (String)object;
                object2 = this.logger.getLevel();
                object2 = ((String)object).equalsIgnoreCase("NULL") ? null : OptionConverter.toLevel((String)object, (Level)object2);
                this.logger.setLevel((Level)object2);
                return;
            }
        } else {
            throw new AttributeNotFoundException("Attribute " + (String)object2 + " not found in " + this.getClass().getName());
        }
    }

    void appenderMBeanRegistration() {
        Enumeration enumeration = this.logger.getAllAppenders();
        while (enumeration.hasMoreElements()) {
            Appender appender = (Appender)enumeration.nextElement();
            this.registerAppenderMBean(appender);
        }
    }

    void registerAppenderMBean(Appender object) {
        String string = object.getName();
        cat.debug("Adding AppenderMBean for appender named " + string);
        try {
            AppenderDynamicMBean appenderDynamicMBean = new AppenderDynamicMBean((Appender)object);
            object = new ObjectName("log4j", "appender", string);
            this.server.registerMBean(appenderDynamicMBean, (ObjectName)object);
            this.dAttributes.add(new MBeanAttributeInfo("appender=" + string, "javax.management.ObjectName", "The " + string + " appender.", true, true, false));
            return;
        }
        catch (Exception exception) {
            cat.error("Could not add appenderMBean for [" + string + "].", exception);
            return;
        }
    }

    public void postRegister(Boolean bl2) {
        this.appenderMBeanRegistration();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

