/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5;

import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.lf5.LogLevelFormatException;

public class LogLevel
implements Serializable {
    public static final LogLevel FATAL = new LogLevel("FATAL", 0);
    public static final LogLevel ERROR = new LogLevel("ERROR", 1);
    public static final LogLevel WARN = new LogLevel("WARN", 2);
    public static final LogLevel INFO = new LogLevel("INFO", 3);
    public static final LogLevel DEBUG = new LogLevel("DEBUG", 4);
    public static final LogLevel SEVERE = new LogLevel("SEVERE", 1);
    public static final LogLevel WARNING = new LogLevel("WARNING", 2);
    public static final LogLevel CONFIG = new LogLevel("CONFIG", 4);
    public static final LogLevel FINE = new LogLevel("FINE", 5);
    public static final LogLevel FINER = new LogLevel("FINER", 6);
    public static final LogLevel FINEST = new LogLevel("FINEST", 7);
    protected String _label;
    protected int _precedence;
    private static LogLevel[] _log4JLevels;
    private static LogLevel[] _jdk14Levels;
    private static LogLevel[] _allDefaultLevels;
    private static Map _logLevelMap;
    private static Map _logLevelColorMap;
    private static Map _registeredLogLevelMap;

    public LogLevel(String string, int n2) {
        this._label = string;
        this._precedence = n2;
    }

    public String getLabel() {
        return this._label;
    }

    public boolean encompasses(LogLevel logLevel) {
        return logLevel.getPrecedence() <= this.getPrecedence();
    }

    public static LogLevel valueOf(String string) {
        Serializable serializable = null;
        if (string != null) {
            string = string.trim().toUpperCase();
            serializable = (LogLevel)_logLevelMap.get(string);
        }
        if (serializable == null && _registeredLogLevelMap.size() > 0) {
            serializable = (LogLevel)_registeredLogLevelMap.get(string);
        }
        if (serializable == null) {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append("Error while trying to parse (" + string + ") into");
            ((StringBuffer)serializable).append(" a LogLevel.");
            throw new LogLevelFormatException(((StringBuffer)serializable).toString());
        }
        return serializable;
    }

    public static LogLevel register(LogLevel logLevel) {
        if (logLevel == null) {
            return null;
        }
        if (_logLevelMap.get(logLevel.getLabel()) == null) {
            return _registeredLogLevelMap.put(logLevel.getLabel(), logLevel);
        }
        return null;
    }

    public static void register(LogLevel[] logLevelArray) {
        if (logLevelArray != null) {
            int n2 = 0;
            while (n2 < logLevelArray.length) {
                LogLevel.register(logLevelArray[n2]);
                ++n2;
            }
        }
    }

    public static void register(List object) {
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                LogLevel.register((LogLevel)object.next());
            }
        }
    }

    public boolean equals(Object object) {
        boolean bl2 = false;
        if (object instanceof LogLevel && this.getPrecedence() == ((LogLevel)object).getPrecedence()) {
            bl2 = true;
        }
        return bl2;
    }

    public int hashCode() {
        return this._label.hashCode();
    }

    public String toString() {
        return this._label;
    }

    public void setLogLevelColorMap(LogLevel logLevel, Color color) {
        _logLevelColorMap.remove(logLevel);
        if (color == null) {
            color = Color.black;
        }
        _logLevelColorMap.put(logLevel, color);
    }

    public static void resetLogLevelColorMap() {
        _logLevelColorMap.clear();
        int n2 = 0;
        while (n2 < _allDefaultLevels.length) {
            _logLevelColorMap.put(_allDefaultLevels[n2], Color.black);
            ++n2;
        }
    }

    public static List getLog4JLevels() {
        return Arrays.asList(_log4JLevels);
    }

    public static List getJdk14Levels() {
        return Arrays.asList(_jdk14Levels);
    }

    public static List getAllDefaultLevels() {
        return Arrays.asList(_allDefaultLevels);
    }

    public static Map getLogLevelColorMap() {
        return _logLevelColorMap;
    }

    protected int getPrecedence() {
        return this._precedence;
    }

    static {
        _registeredLogLevelMap = new HashMap();
        _log4JLevels = new LogLevel[]{FATAL, ERROR, WARN, INFO, DEBUG};
        _jdk14Levels = new LogLevel[]{SEVERE, WARNING, INFO, CONFIG, FINE, FINER, FINEST};
        _allDefaultLevels = new LogLevel[]{FATAL, ERROR, WARN, INFO, DEBUG, SEVERE, WARNING, CONFIG, FINE, FINER, FINEST};
        _logLevelMap = new HashMap();
        int n2 = 0;
        while (n2 < _allDefaultLevels.length) {
            _logLevelMap.put(_allDefaultLevels[n2].getLabel(), _allDefaultLevels[n2]);
            ++n2;
        }
        _logLevelColorMap = new HashMap();
        n2 = 0;
        while (n2 < _allDefaultLevels.length) {
            _logLevelColorMap.put(_allDefaultLevels[n2], Color.black);
            ++n2;
        }
    }
}

