/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer.configure;

import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.LogLevelFormatException;
import org.apache.log4j.lf5.viewer.LogBrokerMonitor;
import org.apache.log4j.lf5.viewer.LogTable;
import org.apache.log4j.lf5.viewer.LogTableColumn;
import org.apache.log4j.lf5.viewer.LogTableColumnFormatException;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryExplorerModel;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryExplorerTree;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNode;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryPath;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;

public class ConfigurationManager {
    private static final String CONFIG_FILE_NAME = "lf5_configuration.xml";
    private static final String NAME = "name";
    private static final String PATH = "path";
    private static final String SELECTED = "selected";
    private static final String EXPANDED = "expanded";
    private static final String CATEGORY = "category";
    private static final String FIRST_CATEGORY_NAME = "Categories";
    private static final String LEVEL = "level";
    private static final String COLORLEVEL = "colorlevel";
    private static final String COLOR = "color";
    private static final String RED = "red";
    private static final String GREEN = "green";
    private static final String BLUE = "blue";
    private static final String COLUMN = "column";
    private static final String NDCTEXTFILTER = "searchtext";
    private LogBrokerMonitor _monitor = null;
    private LogTable _table = null;

    public ConfigurationManager(LogBrokerMonitor logBrokerMonitor, LogTable logTable) {
        this._monitor = logBrokerMonitor;
        this._table = logTable;
        this.load();
    }

    public void save() {
        CategoryNode categoryNode = this._monitor.getCategoryExplorerTree().getExplorerModel().getRootCategoryNode();
        StringBuffer stringBuffer = new StringBuffer(2048);
        this.openXMLDocument(stringBuffer);
        this.openConfigurationXML(stringBuffer);
        this.processLogRecordFilter(this._monitor.getNDCTextFilter(), stringBuffer);
        this.processLogLevels(this._monitor.getLogLevelMenuItems(), stringBuffer);
        this.processLogLevelColors(this._monitor.getLogLevelMenuItems(), LogLevel.getLogLevelColorMap(), stringBuffer);
        this.processLogTableColumns(LogTableColumn.getLogTableColumns(), stringBuffer);
        this.processConfigurationNode(categoryNode, stringBuffer);
        this.closeConfigurationXML(stringBuffer);
        this.store(stringBuffer.toString());
    }

    public void reset() {
        this.deleteConfigurationFile();
        this.collapseTree();
        this.selectAllNodes();
    }

    public static String treePathToString(TreePath serializable) {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = ((TreePath)serializable).getPath();
        int n2 = 1;
        while (n2 < objectArray.length) {
            serializable = (CategoryNode)objectArray[n2];
            if (n2 > 1) {
                stringBuffer.append(".");
            }
            stringBuffer.append(((CategoryNode)serializable).getTitle());
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected void load() {
        Object object = new File(this.getFilename());
        if (((File)object).exists()) {
            try {
                object = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse((File)object);
                this.processRecordFilter((Document)object);
                this.processCategories((Document)object);
                this.processLogLevels((Document)object);
                this.processLogLevelColors((Document)object);
                this.processLogTableColumns((Document)object);
                return;
            }
            catch (Exception exception) {
                System.err.println("Unable process configuration file at " + this.getFilename() + ". Error Message=" + exception.getMessage());
            }
        }
    }

    protected void processRecordFilter(Document object) {
        if ((object = object.getElementsByTagName(NDCTEXTFILTER).item(0)) == null) {
            return;
        }
        object = object.getAttributes();
        if ((object = this.getValue((NamedNodeMap)object, NAME)) == null || ((String)object).equals("")) {
            return;
        }
        this._monitor.setNDCLogRecordFilter((String)object);
    }

    protected void processCategories(Document object) {
        CategoryExplorerTree categoryExplorerTree = this._monitor.getCategoryExplorerTree();
        CategoryExplorerModel categoryExplorerModel = categoryExplorerTree.getExplorerModel();
        NamedNodeMap namedNodeMap = (object = object.getElementsByTagName(CATEGORY)).item(0).getAttributes();
        int n2 = this.getValue(namedNodeMap, NAME).equalsIgnoreCase(FIRST_CATEGORY_NAME) ? 1 : 0;
        int n3 = object.getLength() - 1;
        while (n3 >= n2) {
            namedNodeMap = object.item(n3).getAttributes();
            CategoryNode categoryNode = categoryExplorerModel.addCategory(new CategoryPath(this.getValue(namedNodeMap, PATH)));
            categoryNode.setSelected(this.getValue(namedNodeMap, SELECTED).equalsIgnoreCase("true"));
            this.getValue(namedNodeMap, EXPANDED).equalsIgnoreCase("true");
            categoryExplorerTree.expandPath(categoryExplorerModel.getTreePathToRoot(categoryNode));
            --n3;
        }
    }

    protected void processLogLevels(Document object) {
        object = object.getElementsByTagName(LEVEL);
        Map map = this._monitor.getLogLevelMenuItems();
        int n2 = 0;
        while (n2 < object.getLength()) {
            NamedNodeMap namedNodeMap = object.item(n2).getAttributes();
            String string = this.getValue(namedNodeMap, NAME);
            try {
                ((JCheckBoxMenuItem)map.get(LogLevel.valueOf(string))).setSelected(this.getValue(namedNodeMap, SELECTED).equalsIgnoreCase("true"));
            }
            catch (LogLevelFormatException logLevelFormatException) {}
            ++n2;
        }
    }

    protected void processLogLevelColors(Document object) {
        object = object.getElementsByTagName(COLORLEVEL);
        LogLevel.getLogLevelColorMap();
        int n2 = 0;
        while (n2 < object.getLength()) {
            Object object2 = object.item(n2);
            if (object2 == null) {
                return;
            }
            object2 = object2.getAttributes();
            Object object3 = this.getValue((NamedNodeMap)object2, NAME);
            try {
                object3 = LogLevel.valueOf((String)object3);
                int n3 = Integer.parseInt(this.getValue((NamedNodeMap)object2, RED));
                int n4 = Integer.parseInt(this.getValue((NamedNodeMap)object2, GREEN));
                int n5 = Integer.parseInt(this.getValue((NamedNodeMap)object2, BLUE));
                object2 = new Color(n3, n4, n5);
                if (object3 != null) {
                    ((LogLevel)object3).setLogLevelColorMap((LogLevel)object3, (Color)object2);
                }
            }
            catch (LogLevelFormatException logLevelFormatException) {}
            ++n2;
        }
    }

    protected void processLogTableColumns(Document object) {
        object = object.getElementsByTagName(COLUMN);
        Map map = this._monitor.getLogTableColumnMenuItems();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = 0;
        while (n2 < object.getLength()) {
            Object object2 = object.item(n2);
            if (object2 == null) {
                return;
            }
            object2 = object2.getAttributes();
            Object object3 = this.getValue((NamedNodeMap)object2, NAME);
            try {
                object3 = LogTableColumn.valueOf((String)object3);
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)map.get(object3);
                jCheckBoxMenuItem.setSelected(this.getValue((NamedNodeMap)object2, SELECTED).equalsIgnoreCase("true"));
                if (jCheckBoxMenuItem.isSelected()) {
                    arrayList.add(object3);
                }
            }
            catch (LogTableColumnFormatException logTableColumnFormatException) {}
            if (arrayList.isEmpty()) {
                this._table.setDetailedView();
            } else {
                this._table.setView(arrayList);
            }
            ++n2;
        }
    }

    protected String getValue(NamedNodeMap namedNodeMap, String string) {
        return namedNodeMap.getNamedItem(string).getNodeValue();
    }

    protected void collapseTree() {
        CategoryExplorerTree categoryExplorerTree = this._monitor.getCategoryExplorerTree();
        int n2 = categoryExplorerTree.getRowCount() - 1;
        while (n2 > 0) {
            categoryExplorerTree.collapseRow(n2);
            --n2;
        }
    }

    protected void selectAllNodes() {
        Enumeration<TreeNode> enumeration = this._monitor.getCategoryExplorerTree().getExplorerModel().getRootCategoryNode().breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            ((CategoryNode)enumeration.nextElement()).setSelected(true);
        }
    }

    protected void store(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.getFilename()));
            printWriter.print(string);
            printWriter.close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    protected void deleteConfigurationFile() {
        try {
            File file = new File(this.getFilename());
            if (file.exists()) {
                file.delete();
            }
            return;
        }
        catch (SecurityException securityException) {
            System.err.println("Cannot delete " + this.getFilename() + " because a security violation occured.");
            return;
        }
    }

    protected String getFilename() {
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("file.separator");
        return string + string2 + "lf5" + string2 + CONFIG_FILE_NAME;
    }

    private void processConfigurationNode(CategoryNode object, StringBuffer stringBuffer) {
        CategoryExplorerModel categoryExplorerModel = this._monitor.getCategoryExplorerTree().getExplorerModel();
        object = ((DefaultMutableTreeNode)object).breadthFirstEnumeration();
        while (object.hasMoreElements()) {
            CategoryNode categoryNode = (CategoryNode)object.nextElement();
            this.exportXMLElement(categoryNode, categoryExplorerModel.getTreePathToRoot(categoryNode), stringBuffer);
        }
    }

    private void processLogLevels(Map map, StringBuffer stringBuffer) {
        stringBuffer.append("\t<loglevels>\r\n");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            LogLevel logLevel = (LogLevel)iterator.next();
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)map.get(logLevel);
            this.exportLogLevelXMLElement(logLevel.getLabel(), jCheckBoxMenuItem.isSelected(), stringBuffer);
        }
        stringBuffer.append("\t</loglevels>\r\n");
    }

    private void processLogLevelColors(Map object, Map map, StringBuffer stringBuffer) {
        stringBuffer.append("\t<loglevelcolors>\r\n");
        object = object.keySet().iterator();
        while (object.hasNext()) {
            LogLevel logLevel = (LogLevel)object.next();
            Color color = (Color)map.get(logLevel);
            this.exportLogLevelColorXMLElement(logLevel.getLabel(), color, stringBuffer);
        }
        stringBuffer.append("\t</loglevelcolors>\r\n");
    }

    private void processLogTableColumns(List object, StringBuffer stringBuffer) {
        stringBuffer.append("\t<logtablecolumns>\r\n");
        object = object.iterator();
        while (object.hasNext()) {
            LogTableColumn logTableColumn = (LogTableColumn)object.next();
            JCheckBoxMenuItem jCheckBoxMenuItem = this._monitor.getTableColumnMenuItem(logTableColumn);
            this.exportLogTableColumnXMLElement(logTableColumn.getLabel(), jCheckBoxMenuItem.isSelected(), stringBuffer);
        }
        stringBuffer.append("\t</logtablecolumns>\r\n");
    }

    private void processLogRecordFilter(String string, StringBuffer stringBuffer) {
        stringBuffer.append("\t<searchtext ");
        stringBuffer.append("name=\"").append(string).append("\"");
        stringBuffer.append("/>\r\n");
    }

    private void openXMLDocument(StringBuffer stringBuffer) {
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n");
    }

    private void openConfigurationXML(StringBuffer stringBuffer) {
        stringBuffer.append("<configuration>\r\n");
    }

    private void closeConfigurationXML(StringBuffer stringBuffer) {
        stringBuffer.append("</configuration>\r\n");
    }

    private void exportXMLElement(CategoryNode categoryNode, TreePath treePath, StringBuffer stringBuffer) {
        CategoryExplorerTree categoryExplorerTree = this._monitor.getCategoryExplorerTree();
        stringBuffer.append("\t<category ");
        stringBuffer.append("name=\"").append(categoryNode.getTitle()).append("\" ");
        stringBuffer.append("path=\"").append(ConfigurationManager.treePathToString(treePath)).append("\" ");
        stringBuffer.append("expanded=\"").append(categoryExplorerTree.isExpanded(treePath)).append("\" ");
        stringBuffer.append("selected=\"").append(categoryNode.isSelected()).append("\"/>\r\n");
    }

    private void exportLogLevelXMLElement(String string, boolean bl2, StringBuffer stringBuffer) {
        stringBuffer.append("\t\t<level name");
        stringBuffer.append("=\"").append(string).append("\" ");
        stringBuffer.append("selected=\"").append(bl2);
        stringBuffer.append("\"/>\r\n");
    }

    private void exportLogLevelColorXMLElement(String string, Color color, StringBuffer stringBuffer) {
        stringBuffer.append("\t\t<colorlevel name");
        stringBuffer.append("=\"").append(string).append("\" ");
        stringBuffer.append("red=\"").append(color.getRed()).append("\" ");
        stringBuffer.append("green=\"").append(color.getGreen()).append("\" ");
        stringBuffer.append("blue=\"").append(color.getBlue());
        stringBuffer.append("\"/>\r\n");
    }

    private void exportLogTableColumnXMLElement(String string, boolean bl2, StringBuffer stringBuffer) {
        stringBuffer.append("\t\t<column name");
        stringBuffer.append("=\"").append(string).append("\" ");
        stringBuffer.append("selected=\"").append(bl2);
        stringBuffer.append("\"/>\r\n");
    }
}

