/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.CyclicBuffer;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.TriggeringEventEvaluator;

public class SMTPAppender
extends AppenderSkeleton {
    private String to;
    private String from;
    private String subject;
    private String smtpHost;
    private int bufferSize = 512;
    private boolean locationInfo = false;
    protected CyclicBuffer cb = new CyclicBuffer(this.bufferSize);
    protected Message msg;
    protected TriggeringEventEvaluator evaluator;
    static Class class$org$apache$log4j$spi$TriggeringEventEvaluator;

    public SMTPAppender() {
        this(new bf());
    }

    public SMTPAppender(TriggeringEventEvaluator triggeringEventEvaluator) {
        this.evaluator = triggeringEventEvaluator;
    }

    public void activateOptions() {
        Properties properties = new Properties(System.getProperties());
        if (this.smtpHost != null) {
            ((Hashtable)properties).put("mail.smtp.host", this.smtpHost);
        }
        properties = Session.getInstance((Properties)properties, null);
        this.msg = new MimeMessage((Session)properties);
        try {
            if (this.from != null) {
                this.msg.setFrom((Address)this.getAddress(this.from));
            } else {
                this.msg.setFrom();
            }
            this.msg.setRecipients(Message.RecipientType.TO, (Address[])this.parseAddress(this.to));
            if (this.subject != null) {
                this.msg.setSubject(this.subject);
            }
            return;
        }
        catch (MessagingException messagingException) {
            LogLog.error("Could not activate SMTPAppender options.", messagingException);
            return;
        }
    }

    public void append(LoggingEvent loggingEvent) {
        if (!this.checkEntryConditions()) {
            return;
        }
        loggingEvent.getThreadName();
        loggingEvent.getNDC();
        if (this.locationInfo) {
            loggingEvent.getLocationInformation();
        }
        this.cb.add(loggingEvent);
        if (this.evaluator.isTriggeringEvent(loggingEvent)) {
            this.sendBuffer();
        }
    }

    protected boolean checkEntryConditions() {
        if (this.msg == null) {
            this.errorHandler.error("Message object not configured.");
            return false;
        }
        if (this.evaluator == null) {
            this.errorHandler.error("No TriggeringEventEvaluator is set for appender [" + this.name + "].");
            return false;
        }
        if (this.layout == null) {
            this.errorHandler.error("No layout set for appender named [" + this.name + "].");
            return false;
        }
        return true;
    }

    public synchronized void close() {
        this.closed = true;
    }

    InternetAddress getAddress(String string) {
        try {
            return new InternetAddress(string);
        }
        catch (AddressException addressException) {
            this.errorHandler.error("Could not parse address [" + string + "].", (Exception)((Object)addressException), 6);
            return null;
        }
    }

    InternetAddress[] parseAddress(String string) {
        try {
            return InternetAddress.parse((String)string, (boolean)true);
        }
        catch (AddressException addressException) {
            this.errorHandler.error("Could not parse address [" + string + "].", (Exception)((Object)addressException), 6);
            return null;
        }
    }

    public String getTo() {
        return this.to;
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void sendBuffer() {
        try {
            String[] stringArray;
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.layout.getHeader();
            if (string != null) {
                stringBuffer.append(string);
            }
            int n2 = this.cb.length();
            int n3 = 0;
            while (n3 < n2) {
                stringArray = this.cb.get();
                stringBuffer.append(this.layout.format((LoggingEvent)stringArray));
                if (this.layout.ignoresThrowable() && (stringArray = stringArray.getThrowableStrRep()) != null) {
                    int n4 = 0;
                    while (n4 < stringArray.length) {
                        stringBuffer.append(stringArray[n4]);
                        ++n4;
                    }
                }
                ++n3;
            }
            String string2 = this.layout.getFooter();
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            mimeBodyPart.setContent((Object)stringBuffer.toString(), this.layout.getContentType());
            stringArray = new MimeMultipart();
            stringArray.addBodyPart((BodyPart)mimeBodyPart);
            this.msg.setContent((Multipart)stringArray);
            this.msg.setSentDate(new Date());
            Transport.send((Message)this.msg);
            return;
        }
        catch (Exception exception) {
            LogLog.error("Error occured while sending e-mail notification.", exception);
            return;
        }
    }

    public String getEvaluatorClass() {
        if (this.evaluator == null) {
            return null;
        }
        return this.evaluator.getClass().getName();
    }

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setFrom(String string) {
        this.from = string;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public void setBufferSize(int n2) {
        this.bufferSize = n2;
        this.cb.resize(n2);
    }

    public void setSMTPHost(String string) {
        this.smtpHost = string;
    }

    public String getSMTPHost() {
        return this.smtpHost;
    }

    public void setTo(String string) {
        this.to = string;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setEvaluatorClass(String string) {
        this.evaluator = (TriggeringEventEvaluator)OptionConverter.instantiateByClassName(string, class$org$apache$log4j$spi$TriggeringEventEvaluator == null ? (class$org$apache$log4j$spi$TriggeringEventEvaluator = SMTPAppender.class$("org.apache.log4j.spi.TriggeringEventEvaluator")) : class$org$apache$log4j$spi$TriggeringEventEvaluator, this.evaluator);
    }

    public void setLocationInfo(boolean bl2) {
        this.locationInfo = bl2;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

