/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Vector;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class SocketHubAppender
extends AppenderSkeleton {
    static final int DEFAULT_PORT = 4560;
    private int port = 4560;
    private Vector oosList = new Vector();
    private bh serverMonitor = null;
    private boolean locationInfo = false;

    public SocketHubAppender() {
    }

    public SocketHubAppender(int n2) {
        this.port = n2;
        this.startServer();
    }

    public void activateOptions() {
        this.startServer();
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        LogLog.debug("closing SocketHubAppender " + this.getName());
        this.closed = true;
        this.cleanUp();
        LogLog.debug("SocketHubAppender " + this.getName() + " closed");
    }

    public void cleanUp() {
        LogLog.debug("stopping ServerSocket");
        this.serverMonitor.a();
        this.serverMonitor = null;
        LogLog.debug("closing client connections");
        while (this.oosList.size() != 0) {
            ObjectOutputStream objectOutputStream = (ObjectOutputStream)this.oosList.elementAt(0);
            if (objectOutputStream == null) continue;
            try {
                objectOutputStream.close();
            }
            catch (IOException iOException) {
                LogLog.error("could not close oos.", iOException);
            }
            this.oosList.removeElementAt(0);
        }
    }

    public void append(LoggingEvent loggingEvent) {
        if (loggingEvent == null || this.oosList.size() == 0) {
            return;
        }
        if (this.locationInfo) {
            loggingEvent.getLocationInformation();
        }
        int n2 = 0;
        while (n2 < this.oosList.size()) {
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = (ObjectOutputStream)this.oosList.elementAt(n2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            if (objectOutputStream == null) break;
            try {
                objectOutputStream.writeObject(loggingEvent);
                objectOutputStream.flush();
                objectOutputStream.reset();
            }
            catch (IOException iOException) {
                this.oosList.removeElementAt(n2);
                LogLog.debug("dropped connection");
                --n2;
            }
            ++n2;
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setPort(int n2) {
        this.port = n2;
    }

    public int getPort() {
        return this.port;
    }

    public void setLocationInfo(boolean bl2) {
        this.locationInfo = bl2;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    private void startServer() {
        this.serverMonitor = new bh(this.port, this.oosList);
    }
}

