/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.SyslogQuietWriter;
import org.apache.log4j.helpers.SyslogWriter;
import org.apache.log4j.spi.LoggingEvent;

public class SyslogAppender
extends AppenderSkeleton {
    public static final int LOG_KERN = 0;
    public static final int LOG_USER = 8;
    public static final int LOG_MAIL = 16;
    public static final int LOG_DAEMON = 24;
    public static final int LOG_AUTH = 32;
    public static final int LOG_SYSLOG = 40;
    public static final int LOG_LPR = 48;
    public static final int LOG_NEWS = 56;
    public static final int LOG_UUCP = 64;
    public static final int LOG_CRON = 72;
    public static final int LOG_AUTHPRIV = 80;
    public static final int LOG_FTP = 88;
    public static final int LOG_LOCAL0 = 128;
    public static final int LOG_LOCAL1 = 136;
    public static final int LOG_LOCAL2 = 144;
    public static final int LOG_LOCAL3 = 152;
    public static final int LOG_LOCAL4 = 160;
    public static final int LOG_LOCAL5 = 168;
    public static final int LOG_LOCAL6 = 176;
    public static final int LOG_LOCAL7 = 184;
    protected static final int SYSLOG_HOST_OI = 0;
    protected static final int FACILITY_OI = 1;
    static final String TAB = "    ";
    int syslogFacility = 8;
    String facilityStr;
    boolean facilityPrinting = false;
    SyslogQuietWriter sqw;
    String syslogHost;

    public SyslogAppender() {
        this.initSyslogFacilityStr();
    }

    public SyslogAppender(Layout layout, int n2) {
        this.layout = layout;
        this.syslogFacility = n2;
        this.initSyslogFacilityStr();
    }

    public SyslogAppender(Layout layout, String string, int n2) {
        this(layout, n2);
        this.setSyslogHost(string);
    }

    public synchronized void close() {
        this.closed = true;
        this.sqw = null;
    }

    private void initSyslogFacilityStr() {
        this.facilityStr = SyslogAppender.getFacilityString(this.syslogFacility);
        if (this.facilityStr == null) {
            System.err.println("\"" + this.syslogFacility + "\" is an unknown syslog facility. Defaulting to \"USER\".");
            this.syslogFacility = 8;
            this.facilityStr = "user:";
            return;
        }
        this.facilityStr = this.facilityStr + ":";
    }

    public static String getFacilityString(int n2) {
        switch (n2) {
            case 0: {
                return "kern";
            }
            case 8: {
                return "user";
            }
            case 16: {
                return "mail";
            }
            case 24: {
                return "daemon";
            }
            case 32: {
                return "auth";
            }
            case 40: {
                return "syslog";
            }
            case 48: {
                return "lpr";
            }
            case 56: {
                return "news";
            }
            case 64: {
                return "uucp";
            }
            case 72: {
                return "cron";
            }
            case 80: {
                return "authpriv";
            }
            case 88: {
                return "ftp";
            }
            case 128: {
                return "local0";
            }
            case 136: {
                return "local1";
            }
            case 144: {
                return "local2";
            }
            case 152: {
                return "local3";
            }
            case 160: {
                return "local4";
            }
            case 168: {
                return "local5";
            }
            case 176: {
                return "local6";
            }
            case 184: {
                return "local7";
            }
        }
        return null;
    }

    public static int getFacility(String string) {
        if (string != null) {
            string = string.trim();
        }
        if ("KERN".equalsIgnoreCase(string)) {
            return 0;
        }
        if ("USER".equalsIgnoreCase(string)) {
            return 8;
        }
        if ("MAIL".equalsIgnoreCase(string)) {
            return 16;
        }
        if ("DAEMON".equalsIgnoreCase(string)) {
            return 24;
        }
        if ("AUTH".equalsIgnoreCase(string)) {
            return 32;
        }
        if ("SYSLOG".equalsIgnoreCase(string)) {
            return 40;
        }
        if ("LPR".equalsIgnoreCase(string)) {
            return 48;
        }
        if ("NEWS".equalsIgnoreCase(string)) {
            return 56;
        }
        if ("UUCP".equalsIgnoreCase(string)) {
            return 64;
        }
        if ("CRON".equalsIgnoreCase(string)) {
            return 72;
        }
        if ("AUTHPRIV".equalsIgnoreCase(string)) {
            return 80;
        }
        if ("FTP".equalsIgnoreCase(string)) {
            return 88;
        }
        if ("LOCAL0".equalsIgnoreCase(string)) {
            return 128;
        }
        if ("LOCAL1".equalsIgnoreCase(string)) {
            return 136;
        }
        if ("LOCAL2".equalsIgnoreCase(string)) {
            return 144;
        }
        if ("LOCAL3".equalsIgnoreCase(string)) {
            return 152;
        }
        if ("LOCAL4".equalsIgnoreCase(string)) {
            return 160;
        }
        if ("LOCAL5".equalsIgnoreCase(string)) {
            return 168;
        }
        if ("LOCAL6".equalsIgnoreCase(string)) {
            return 176;
        }
        if ("LOCAL7".equalsIgnoreCase(string)) {
            return 184;
        }
        return -1;
    }

    public void append(LoggingEvent stringArray) {
        int n2;
        if (!this.isAsSevereAsThreshold(stringArray.getLevel())) {
            return;
        }
        if (this.sqw == null) {
            this.errorHandler.error("No syslog host is set for SyslogAppedender named \"" + this.name + "\".");
            return;
        }
        String string = (this.facilityPrinting ? this.facilityStr : "") + this.layout.format((LoggingEvent)stringArray);
        this.sqw.setLevel(stringArray.getLevel().getSyslogEquivalent());
        this.sqw.write(string);
        stringArray = stringArray.getThrowableStrRep();
        if (stringArray != null && (n2 = stringArray.length) > 0) {
            this.sqw.write(stringArray[0]);
            int n3 = 1;
            while (n3 < n2) {
                this.sqw.write(TAB + stringArray[n3].substring(1));
                ++n3;
            }
        }
    }

    public void activateOptions() {
    }

    public boolean requiresLayout() {
        return true;
    }

    public void setSyslogHost(String string) {
        this.sqw = new SyslogQuietWriter(new SyslogWriter(string), this.syslogFacility, this.errorHandler);
        this.syslogHost = string;
    }

    public String getSyslogHost() {
        return this.syslogHost;
    }

    public void setFacility(String string) {
        if (string == null) {
            return;
        }
        this.syslogFacility = SyslogAppender.getFacility(string);
        if (this.syslogFacility == -1) {
            System.err.println("[" + string + "] is an unknown syslog facility. Defaulting to [USER].");
            this.syslogFacility = 8;
        }
        this.initSyslogFacilityStr();
        if (this.sqw != null) {
            this.sqw.setSyslogFacility(this.syslogFacility);
        }
    }

    public String getFacility() {
        return SyslogAppender.getFacilityString(this.syslogFacility);
    }

    public void setFacilityPrinting(boolean bl2) {
        this.facilityPrinting = bl2;
    }

    public boolean getFacilityPrinting() {
        return this.facilityPrinting;
    }
}

