/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.config.PropertySetter;
import org.apache.log4j.helpers.FileWatchdog;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.or.RendererMap;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RendererSupport;
import org.apache.log4j.xml.Log4jEntityResolver;
import org.apache.log4j.xml.SAXErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DOMConfigurator
implements Configurator {
    static final String CONFIGURATION_TAG = "log4j:configuration";
    static final String OLD_CONFIGURATION_TAG = "configuration";
    static final String RENDERER_TAG = "renderer";
    static final String APPENDER_TAG = "appender";
    static final String APPENDER_REF_TAG = "appender-ref";
    static final String PARAM_TAG = "param";
    static final String LAYOUT_TAG = "layout";
    static final String CATEGORY = "category";
    static final String LOGGER = "logger";
    static final String LOGGER_REF = "logger-ref";
    static final String CATEGORY_FACTORY_TAG = "categoryFactory";
    static final String NAME_ATTR = "name";
    static final String CLASS_ATTR = "class";
    static final String VALUE_ATTR = "value";
    static final String ROOT_TAG = "root";
    static final String ROOT_REF = "root-ref";
    static final String LEVEL_TAG = "level";
    static final String PRIORITY_TAG = "priority";
    static final String FILTER_TAG = "filter";
    static final String ERROR_HANDLER_TAG = "errorHandler";
    static final String REF_ATTR = "ref";
    static final String ADDITIVITY_ATTR = "additivity";
    static final String THRESHOLD_ATTR = "threshold";
    static final String CONFIG_DEBUG_ATTR = "configDebug";
    static final String INTERNAL_DEBUG_ATTR = "debug";
    static final String RENDERING_CLASS_ATTR = "renderingClass";
    static final String RENDERED_CLASS_ATTR = "renderedClass";
    static final String EMPTY_STR = "";
    static final Class[] ONE_STRING_PARAM = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DOMConfigurator.class$("java.lang.String")) : class$java$lang$String};
    static final String dbfKey = "javax.xml.parsers.DocumentBuilderFactory";
    Hashtable appenderBag = new Hashtable();
    Properties props;
    LoggerRepository repository;
    static Class class$java$lang$String;
    static Class class$org$apache$log4j$spi$ErrorHandler;
    static Class class$org$apache$log4j$spi$Filter;
    static Class class$org$apache$log4j$spi$LoggerFactory;

    protected Appender findAppenderByName(Document object, String string) {
        Object object2 = (Appender)this.appenderBag.get(string);
        if (object2 != null) {
            return object2;
        }
        object2 = null;
        object = object.getElementsByTagName(APPENDER_TAG);
        int n2 = 0;
        while (n2 < object.getLength()) {
            Node node = object.item(n2);
            Node node2 = node.getAttributes().getNamedItem(NAME_ATTR);
            if (string.equals(node2.getNodeValue())) {
                object2 = (Element)node;
                break;
            }
            ++n2;
        }
        if (object2 == null) {
            LogLog.error("No appender named [" + string + "] could be found.");
            return null;
        }
        object2 = this.parseAppender((Element)object2);
        this.appenderBag.put(string, object2);
        return object2;
    }

    protected Appender findAppenderByReference(Element node) {
        String string = this.subst(node.getAttribute(REF_ATTR));
        node = node.getOwnerDocument();
        return this.findAppenderByName((Document)node, string);
    }

    protected Appender parseAppender(Element object) {
        Object object2 = this.subst(object.getAttribute(CLASS_ATTR));
        LogLog.debug("Class name: [" + (String)object2 + ']');
        try {
            object2 = (Appender)Loader.loadClass((String)object2).newInstance();
            PropertySetter propertySetter = new PropertySetter(object2);
            object2.setName(this.subst(object.getAttribute(NAME_ATTR)));
            object = object.getChildNodes();
            int n2 = object.getLength();
            int n3 = 0;
            while (n3 < n2) {
                Node node = object.item(n3);
                if (node.getNodeType() == 1) {
                    if ((node = (Element)node).getTagName().equals(PARAM_TAG)) {
                        this.setParameter((Element)node, propertySetter);
                    } else if (node.getTagName().equals(LAYOUT_TAG)) {
                        object2.setLayout(this.parseLayout((Element)node));
                    } else if (node.getTagName().equals(FILTER_TAG)) {
                        this.parseFilters((Element)node, (Appender)object2);
                    } else if (node.getTagName().equals(ERROR_HANDLER_TAG)) {
                        this.parseErrorHandler((Element)node, (Appender)object2);
                    } else if (node.getTagName().equals(APPENDER_REF_TAG)) {
                        String string = this.subst(node.getAttribute(REF_ATTR));
                        if (object2 instanceof AppenderAttachable) {
                            AppenderAttachable appenderAttachable = (AppenderAttachable)object2;
                            LogLog.debug("Attaching appender named [" + string + "] to appender named [" + object2.getName() + "].");
                            appenderAttachable.addAppender(this.findAppenderByReference((Element)node));
                        } else {
                            LogLog.error("Requesting attachment of appender named [" + string + "] to appender named [" + object2.getName() + "] which does not implement org.apache.log4j.spi.AppenderAttachable.");
                        }
                    }
                }
                ++n3;
            }
            propertySetter.activate();
            return object2;
        }
        catch (Exception exception) {
            LogLog.error("Could not create an Appender. Reported error follows.", exception);
            return null;
        }
    }

    protected void parseErrorHandler(Element object, Appender appender) {
        ErrorHandler errorHandler = (ErrorHandler)OptionConverter.instantiateByClassName(this.subst(object.getAttribute(CLASS_ATTR)), class$org$apache$log4j$spi$ErrorHandler == null ? (class$org$apache$log4j$spi$ErrorHandler = DOMConfigurator.class$("org.apache.log4j.spi.ErrorHandler")) : class$org$apache$log4j$spi$ErrorHandler, null);
        if (errorHandler != null) {
            errorHandler.setAppender(appender);
            PropertySetter propertySetter = new PropertySetter(errorHandler);
            object = object.getChildNodes();
            int n2 = object.getLength();
            int n3 = 0;
            while (n3 < n2) {
                Object object2 = object.item(n3);
                if (object2.getNodeType() == 1) {
                    String string = (object2 = (Element)object2).getTagName();
                    if (string.equals(PARAM_TAG)) {
                        this.setParameter((Element)object2, propertySetter);
                    } else if (string.equals(APPENDER_REF_TAG)) {
                        errorHandler.setBackupAppender(this.findAppenderByReference((Element)object2));
                    } else if (string.equals(LOGGER_REF)) {
                        object2 = object2.getAttribute(REF_ATTR);
                        object2 = this.repository.getLogger((String)object2);
                        errorHandler.setLogger((Logger)object2);
                    } else if (string.equals(ROOT_REF)) {
                        object2 = this.repository.getRootLogger();
                        errorHandler.setLogger((Logger)object2);
                    }
                }
                ++n3;
            }
            propertySetter.activate();
            appender.setErrorHandler(errorHandler);
        }
    }

    protected void parseFilters(Element object, Appender appender) {
        Filter filter = (Filter)OptionConverter.instantiateByClassName(this.subst(object.getAttribute(CLASS_ATTR)), class$org$apache$log4j$spi$Filter == null ? (class$org$apache$log4j$spi$Filter = DOMConfigurator.class$("org.apache.log4j.spi.Filter")) : class$org$apache$log4j$spi$Filter, null);
        if (filter != null) {
            PropertySetter propertySetter = new PropertySetter(filter);
            object = object.getChildNodes();
            int n2 = object.getLength();
            int n3 = 0;
            while (n3 < n2) {
                Node node = object.item(n3);
                if (node.getNodeType() == 1 && (node = (Element)node).getTagName().equals(PARAM_TAG)) {
                    this.setParameter((Element)node, propertySetter);
                }
                ++n3;
            }
            propertySetter.activate();
            LogLog.debug("Adding filter of type [" + filter.getClass() + "] to appender named [" + appender.getName() + "].");
            appender.addFilter(filter);
        }
    }

    protected void parseCategory(Element element) {
        String string = this.subst(element.getAttribute(NAME_ATTR));
        Object object = this.subst(element.getAttribute(CLASS_ATTR));
        if (EMPTY_STR.equals(object)) {
            LogLog.debug("Retreiving an instance of org.apache.log4j.Logger.");
            object = this.repository.getLogger(string);
        } else {
            LogLog.debug("Desired logger sub-class: [" + (String)object + ']');
            try {
                object = (Logger)Loader.loadClass((String)object).getMethod("getLogger", ONE_STRING_PARAM).invoke(null, string);
            }
            catch (Exception exception) {
                LogLog.error("Could not retrieve category [" + string + "]. Reported error follows.", exception);
                return;
            }
        }
        Object object2 = object;
        synchronized (object2) {
            boolean bl2 = OptionConverter.toBoolean(this.subst(element.getAttribute(ADDITIVITY_ATTR)), true);
            LogLog.debug("Setting [" + ((Category)object).getName() + "] additivity to [" + bl2 + "].");
            ((Category)object).setAdditivity(bl2);
            this.parseChildrenOfLoggerElement(element, (Logger)object, false);
            return;
        }
    }

    protected void parseCategoryFactory(Element node) {
        Object object = this.subst(node.getAttribute(CLASS_ATTR));
        if (EMPTY_STR.equals(object)) {
            LogLog.error("Category Factory tag class attribute not found.");
            LogLog.debug("No Category Factory configured.");
            return;
        }
        LogLog.debug("Desired category factory: [" + (String)object + ']');
        object = OptionConverter.instantiateByClassName((String)object, class$org$apache$log4j$spi$LoggerFactory == null ? (class$org$apache$log4j$spi$LoggerFactory = DOMConfigurator.class$("org.apache.log4j.spi.LoggerFactory")) : class$org$apache$log4j$spi$LoggerFactory, null);
        object = new PropertySetter(object);
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        int n3 = 0;
        while (n3 < n2) {
            node = nodeList.item(n3);
            if (node.getNodeType() == 1 && node.getTagName().equals(PARAM_TAG)) {
                this.setParameter((Element)node, (PropertySetter)object);
            }
            ++n3;
        }
    }

    protected void parseRoot(Element element) {
        Logger logger;
        Logger logger2 = logger = this.repository.getRootLogger();
        synchronized (logger) {
            this.parseChildrenOfLoggerElement(element, logger, true);
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    protected void parseChildrenOfLoggerElement(Element object, Logger logger, boolean bl2) {
        PropertySetter propertySetter = new PropertySetter(logger);
        logger.removeAllAppenders();
        object = object.getChildNodes();
        int n2 = object.getLength();
        int n3 = 0;
        while (n3 < n2) {
            Object object2 = object.item(n3);
            if (object2.getNodeType() == 1) {
                Object object3 = (Element)object2;
                String string = object3.getTagName();
                if (string.equals(APPENDER_REF_TAG)) {
                    object2 = (Element)object2;
                    object3 = this.findAppenderByReference((Element)object2);
                    object2 = this.subst(object2.getAttribute(REF_ATTR));
                    if (object3 != null) {
                        LogLog.debug("Adding appender named [" + (String)object2 + "] to category [" + logger.getName() + "].");
                    } else {
                        LogLog.debug("Appender named [" + (String)object2 + "] not found.");
                    }
                    logger.addAppender((Appender)object3);
                } else if (string.equals(LEVEL_TAG)) {
                    this.parseLevel((Element)object3, logger, bl2);
                } else if (string.equals(PRIORITY_TAG)) {
                    this.parseLevel((Element)object3, logger, bl2);
                } else if (string.equals(PARAM_TAG)) {
                    this.setParameter((Element)object3, propertySetter);
                }
            }
            ++n3;
        }
        propertySetter.activate();
    }

    protected Layout parseLayout(Element object) {
        Object object2 = this.subst(object.getAttribute(CLASS_ATTR));
        LogLog.debug("Parsing layout of class: \"" + (String)object2 + "\"");
        try {
            object2 = (Layout)Loader.loadClass((String)object2).newInstance();
            PropertySetter propertySetter = new PropertySetter(object2);
            object = object.getChildNodes();
            int n2 = object.getLength();
            int n3 = 0;
            while (n3 < n2) {
                Node node = object.item(n3);
                if (node.getNodeType() == 1 && (node = (Element)node).getTagName().equals(PARAM_TAG)) {
                    this.setParameter((Element)node, propertySetter);
                }
                ++n3;
            }
            propertySetter.activate();
            return object2;
        }
        catch (Exception exception) {
            LogLog.error("Could not create the Layout. Reported error follows.", exception);
            return null;
        }
    }

    protected void parseRenderer(Element object) {
        String string = this.subst(object.getAttribute(RENDERING_CLASS_ATTR));
        object = this.subst(object.getAttribute(RENDERED_CLASS_ATTR));
        if (this.repository instanceof RendererSupport) {
            RendererMap.addRenderer((RendererSupport)((Object)this.repository), (String)object, string);
        }
    }

    protected void parseLevel(Element object, Logger logger, boolean bl2) {
        String string = logger.getName();
        if (bl2) {
            string = ROOT_TAG;
        }
        String string2 = this.subst(object.getAttribute(VALUE_ATTR));
        LogLog.debug("Level value for " + string + " is  [" + string2 + "].");
        if ("inherited".equalsIgnoreCase(string2) || "null".equalsIgnoreCase(string2)) {
            if (bl2) {
                LogLog.error("Root level cannot be inherited. Ignoring directive.");
            } else {
                logger.setLevel(null);
            }
        } else if (EMPTY_STR.equals(object = this.subst(object.getAttribute(CLASS_ATTR)))) {
            logger.setLevel(OptionConverter.toLevel(string2, Level.DEBUG));
        } else {
            LogLog.debug("Desired Level sub-class: [" + (String)object + ']');
            try {
                object = (Level)Loader.loadClass((String)object).getMethod("toLevel", ONE_STRING_PARAM).invoke(null, string2);
                logger.setLevel((Level)object);
            }
            catch (Exception exception) {
                LogLog.error("Could not create level [" + string2 + "]. Reported error follows.", exception);
                return;
            }
        }
        LogLog.debug(string + " level set to " + logger.getLevel());
    }

    protected void setParameter(Element object, PropertySetter propertySetter) {
        String string = this.subst(object.getAttribute(NAME_ATTR));
        object = object.getAttribute(VALUE_ATTR);
        object = this.subst(OptionConverter.convertSpecialChars((String)object));
        propertySetter.setProperty(string, (String)object);
    }

    public static void configure(Element element) {
        new DOMConfigurator().doConfigure(element, LogManager.getLoggerRepository());
    }

    public static void configureAndWatch(String string) {
        DOMConfigurator.configureAndWatch(string, 60000L);
    }

    public static void configureAndWatch(String object, long l2) {
        object = new bn((String)object);
        ((FileWatchdog)object).setDelay(l2);
        ((Thread)object).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doConfigure(String string, LoggerRepository loggerRepository) {
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(string);
                this.doConfigure(fileInputStream, loggerRepository);
            }
            catch (IOException iOException) {
                LogLog.error("Could not open [" + string + "].", iOException);
                Object var2_4 = null;
                if (fileInputStream == null) return;
                try {
                    fileInputStream.close();
                    return;
                }
                catch (IOException iOException2) {
                    LogLog.error("Could not close [" + string + "].", iOException2);
                }
                return;
            }
            loggerRepository = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            loggerRepository = null;
            if (fileInputStream == null) throw throwable;
            try {}
            catch (IOException iOException) {
                LogLog.error("Could not close [" + string + "].", iOException);
                throw throwable;
            }
            fileInputStream.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            LogLog.error("Could not close [" + string + "].", iOException);
            return;
        }
        fileInputStream.close();
    }

    public void doConfigure(URL uRL, LoggerRepository loggerRepository) {
        try {
            this.doConfigure(uRL.openStream(), loggerRepository);
            return;
        }
        catch (IOException iOException) {
            LogLog.error("Could not open [" + uRL + "].", iOException);
            return;
        }
    }

    public void doConfigure(InputStream inputStream, LoggerRepository loggerRepository) {
        this.doConfigure(new InputSource(inputStream), loggerRepository);
    }

    public void doConfigure(Reader reader, LoggerRepository loggerRepository) {
        this.doConfigure(new InputSource(reader), loggerRepository);
    }

    protected void doConfigure(InputSource inputSource, LoggerRepository object) {
        this.repository = object;
        try {
            LogLog.debug("System property is :" + OptionConverter.getSystemProperty(dbfKey, null));
            object = DocumentBuilderFactory.newInstance();
            LogLog.debug("Standard DocumentBuilderFactory search succeded.");
            LogLog.debug("DocumentBuilderFactory is: " + object.getClass().getName());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            object = factoryConfigurationError;
            Exception exception = factoryConfigurationError.getException();
            LogLog.debug("Could not instantiate a DocumentBuilderFactory.", exception);
            throw object;
        }
        try {
            ((DocumentBuilderFactory)object).setValidating(true);
            object = ((DocumentBuilderFactory)object).newDocumentBuilder();
            ((DocumentBuilder)object).setErrorHandler(new SAXErrorHandler());
            ((DocumentBuilder)object).setEntityResolver(new Log4jEntityResolver());
            inputSource.setSystemId("dummy://log4j.dtd");
            Document document = ((DocumentBuilder)object).parse(inputSource);
            this.parse(document.getDocumentElement());
            return;
        }
        catch (Exception exception) {
            LogLog.error("Could not parse input source [" + inputSource + "].", exception);
            return;
        }
    }

    public void doConfigure(Element element, LoggerRepository loggerRepository) {
        this.repository = loggerRepository;
        this.parse(element);
    }

    public static void configure(String string) {
        new DOMConfigurator().doConfigure(string, LogManager.getLoggerRepository());
    }

    public static void configure(URL uRL) {
        new DOMConfigurator().doConfigure(uRL, LogManager.getLoggerRepository());
    }

    protected void parse(Element object) {
        Object object2 = object.getTagName();
        if (!((String)object2).equals(CONFIGURATION_TAG)) {
            if (((String)object2).equals(OLD_CONFIGURATION_TAG)) {
                LogLog.warn("The <configuration> element has been deprecated.");
                LogLog.warn("Use the <log4j:configuration> element instead.");
            } else {
                LogLog.error("DOM element is - not a <log4j:configuration> element.");
                return;
            }
        }
        object2 = this.subst(object.getAttribute(INTERNAL_DEBUG_ATTR));
        LogLog.debug("debug attribute= \"" + (String)object2 + "\".");
        if (!((String)object2).equals(EMPTY_STR) && !((String)object2).equals("null")) {
            LogLog.setInternalDebugging(OptionConverter.toBoolean((String)object2, true));
        } else {
            LogLog.debug("Ignoring debug attribute.");
        }
        object2 = this.subst(object.getAttribute(CONFIG_DEBUG_ATTR));
        if (!((String)object2).equals(EMPTY_STR) && !((String)object2).equals("null")) {
            LogLog.warn("The \"configDebug\" attribute is deprecated.");
            LogLog.warn("Use the \"debug\" attribute instead.");
            LogLog.setInternalDebugging(OptionConverter.toBoolean((String)object2, true));
        }
        object2 = this.subst(object.getAttribute(THRESHOLD_ATTR));
        LogLog.debug("Threshold =\"" + (String)object2 + "\".");
        if (!EMPTY_STR.equals(object2) && !"null".equals(object2)) {
            this.repository.setThreshold((String)object2);
        }
        NodeList nodeList = object.getChildNodes();
        int n2 = nodeList.getLength();
        int n3 = 0;
        while (n3 < n2) {
            object = nodeList.item(n3);
            if (object.getNodeType() == 1 && (object2 = object).getTagName().equals(CATEGORY_FACTORY_TAG)) {
                this.parseCategoryFactory((Element)object2);
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            object = nodeList.item(n3);
            if (object.getNodeType() == 1) {
                object2 = object;
                if (((String)(object = object2.getTagName())).equals(CATEGORY) || ((String)object).equals(LOGGER)) {
                    this.parseCategory((Element)object2);
                } else if (((String)object).equals(ROOT_TAG)) {
                    this.parseRoot((Element)object2);
                } else if (((String)object).equals(RENDERER_TAG)) {
                    this.parseRenderer((Element)object2);
                }
            }
            ++n3;
        }
    }

    protected String subst(String string) {
        try {
            return OptionConverter.substVars(string, this.props);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogLog.warn("Could not perform variable substitution.", illegalArgumentException);
            return string;
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

