/*
 * Decompiled with CFR 0.152.
 */
import com.isbc.smartcard.esmarttoken.api.Pkcs11Wrapper;
import com.isbc.smartcard.esmarttoken.utils.HexUtils;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javax.smartcardio.CardTerminal;
import org.apache.log4j.Logger;

public class CreateCSR {
    private static Logger logger = Logger.getLogger(CreateCSR.class);
    private static String SCRIPT_NAME = "CreateCSR";

    private CreateCSR() {
    }

    public static void main(String[] object) {
        Object object2 = new CreateCSR();
        CreateCSR$CsrParams createCSR$CsrParams = ((CreateCSR)object2).getNewParams();
        if (((String[])object).length < 3 || !((CreateCSR)object2).parseArgs((String[])object, createCSR$CsrParams)) {
            ((CreateCSR)object2).printUsage();
            return;
        }
        ((CreateCSR)object2).printArgs(createCSR$CsrParams);
        object = new Pkcs11Wrapper();
        object2 = null;
        if (!createCSR$CsrParams.getReader().isEmpty() && (object2 = Utils.getTerminal(createCSR$CsrParams.getReader())) == null) {
            System.err.print("No reader found\n");
            return;
        }
        String string = createCSR$CsrParams.getModule();
        if (string.isEmpty()) {
            string = Utils.getDefaultModuleName();
        }
        ArrayList arrayList = new ArrayList();
        long l2 = -1L;
        try {
            l2 = object.createCSRWrap((CardTerminal)object2, string, createCSR$CsrParams.getPin().getBytes(), HexUtils.decodeHex(createCSR$CsrParams.getKeyId()), HexUtils.decodeHex(createCSR$CsrParams.getKeyId()), createCSR$CsrParams.getDn().toArray(new String[0]), createCSR$CsrParams.getAttr().toArray(new String[0]), createCSR$CsrParams.getExt().toArray(new String[0]), arrayList);
        }
        catch (n n2) {
            logger.error("ERROR decoding Key ID", n2);
        }
        if (l2 != 0L) {
            System.err.print("ERROR creating CSR. Return code: " + l2 + "\n\n");
            return;
        }
        if (arrayList.isEmpty()) {
            logger.error("ERROR: no data found");
            return;
        }
        try {
            object = arrayList.toArray(new Byte[0]);
            object2 = new FileOutputStream(createCSR$CsrParams.getFile());
            ((FileOutputStream)object2).write("-----BEGIN CERTIFICATE REQUEST-----\n".getBytes());
            ((FileOutputStream)object2).write(q.a(r.a((Byte[])object)));
            ((FileOutputStream)object2).write("\n-----END CERTIFICATE REQUEST-----".getBytes());
            ((FileOutputStream)object2).close();
            System.out.print("CSR was successfully saved to \"" + createCSR$CsrParams.getFile() + "\"\n\n");
            return;
        }
        catch (Exception exception) {
            logger.error("Write file error", exception);
            return;
        }
    }

    private CreateCSR$CsrParams getNewParams() {
        return new CreateCSR$CsrParams(this);
    }

    private boolean parseArgs(String[] stringArray, CreateCSR$CsrParams createCSR$CsrParams) {
        boolean bl2 = false;
        int n2 = 0;
        for (String string : stringArray) {
            String[] stringArray2 = string.split("=");
            if (stringArray2.length < 2 || stringArray2[1] == null) {
                System.err.print("Parse error for \"" + string + "\"\n");
                break;
            }
            if (string.startsWith("--terminal=")) {
                createCSR$CsrParams.setReader(stringArray2[1]);
                continue;
            }
            if (string.startsWith("--module=")) {
                createCSR$CsrParams.setModule(stringArray2[1]);
                continue;
            }
            if (string.startsWith("--keyid=")) {
                n2 |= 1;
                createCSR$CsrParams.setKeyId(stringArray2[1]);
                continue;
            }
            if (string.startsWith("--file=")) {
                n2 |= 2;
                createCSR$CsrParams.setFile(stringArray2[1]);
                continue;
            }
            if (string.startsWith("--dn=") && stringArray2.length > 2) {
                n2 |= 4;
                createCSR$CsrParams.getDn().add(stringArray2[1]);
                createCSR$CsrParams.getDn().add(stringArray2[2]);
                continue;
            }
            if (string.startsWith("--pin=")) {
                n2 |= 8;
                createCSR$CsrParams.setPin(stringArray2[1]);
                continue;
            }
            if (string.startsWith("--attr=") && stringArray2.length > 2) {
                createCSR$CsrParams.getAttr().add(stringArray2[1]);
                createCSR$CsrParams.getAttr().add(stringArray2[2]);
                continue;
            }
            if (!string.startsWith("--ext=") || stringArray2.length <= 3) continue;
            createCSR$CsrParams.getExt().add(stringArray2[1]);
            createCSR$CsrParams.getExt().add(stringArray2[2]);
            if (stringArray2[3].equalsIgnoreCase("TRUE")) {
                createCSR$CsrParams.getExt().add("1");
                continue;
            }
            createCSR$CsrParams.getExt().add("0");
        }
        if (n2 == 15) {
            bl2 = true;
        }
        return bl2;
    }

    private void printUsage() {
        String string = "Usage: " + SCRIPT_NAME + " [OPTIONS]\nOptions:\n--pin \t\tUser PIN for smart card or USB token\n--terminal \tReader name. Optional, if not set, the first available reader is used\n--module \tPath to PKCS#11 library. Optional, if not set, the default library path and name is used\n--keyid \tID of private key object\n--dn \t\tMandatory distinguished Name for CSR. Can be used more than one time, values should be set according to RFC 5280, RFC 4491 or http://www.esmart.ru/upload/esmart/download/OID%20list%20for%20CSR.pdf. " + "Format: \"key=value\"\n--attr \t\tOptional additional attribute. Can be used more than one time. Format: \"key=value\"\n--ext \t\tOptional extension. Can be used more than one time. Format: \"key=value=FLAG\", where FLAG can be TRUE or FALSE to specify if this extension is mandatory or not\n--file \t\tPath to file where CSR will be stored\n\n\nExamples: \n" + SCRIPT_NAME + " --pin=12345678 --keyid=1234 --dn=\"CN=Ivan Ivanov\" --dn=\"emailAddress=ivanov@mail.ru\" --attr=\"challengePassword=123\" --ext=\"keyUsage=digitalSignature,keyEncipherment=TRUE\" --ext=\"extendedKeyUsage=1.3.6.1.4.1.311.20.2.2=FALSE\" --file=newcsr.txt\n\n" + SCRIPT_NAME + " --pin=12345678 --keyid=1234 --dn=\"CN=OOO Company\" --dn=\"emailAddress=ivanov@mail.ru\" --dn=\"2.5.4.9=company address\" --dn=\"S=77 Moscow\" --dn=\"C=RU\" --dn=\"givenName=Ivan Ivanovich\" --dn=\"surname=Ivanov\" --dn=\"title=Director\" --dn=\"O=OOO Company\" --dn=\"1.2.643.100.1=1234567890123\" --dn=\"1.2.643.100.3=12345678901\" --dn=\"1.2.643.3.131.1.1=001234567890\" --ext=\"keyUsage=digitalSignature,keyEncipherment,nonRepudiation,dataEncipherment=TRUE\"  --ext=\"1.2.643.100.111=DER:0C1045534D415254546F6B656E20474F5354=FALSE\" --file=newcsr-gost.txt\n\n";
        System.out.print(string);
    }

    private void printArgs(CreateCSR$CsrParams createCSR$CsrParams) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        String string = "Start generation of Certificate Signing Request (CSR) for the following params:\n\tPIN: \t\t********\n\tTerminal: \t" + (createCSR$CsrParams.getReader().isEmpty() ? "[first available]" : createCSR$CsrParams.getReader()) + "\n\tModule: \t" + (createCSR$CsrParams.getModule().isEmpty() ? "[default]" : createCSR$CsrParams.getModule()) + "\n\tKeyID: \t\t" + createCSR$CsrParams.getKeyId() + "\n\tDN:\n";
        stringBuilder.append(string);
        for (n2 = 0; n2 < createCSR$CsrParams.getDn().size(); n2 += 2) {
            stringBuilder.append("\t\t" + (String)createCSR$CsrParams.getDn().get(n2) + "=" + (String)createCSR$CsrParams.getDn().get(n2 + 1) + "\n");
        }
        stringBuilder.append("\tAdditional attribute:\n");
        for (n2 = 0; n2 < createCSR$CsrParams.getAttr().size(); n2 += 2) {
            stringBuilder.append("\t\t" + (String)createCSR$CsrParams.getAttr().get(n2) + "=" + (String)createCSR$CsrParams.getAttr().get(n2 + 1) + "\n");
        }
        stringBuilder.append("\tExtensions:\n");
        for (n2 = 0; n2 < createCSR$CsrParams.getExt().size(); n2 += 3) {
            stringBuilder.append("\t\t" + (String)createCSR$CsrParams.getExt().get(n2) + "=" + (String)createCSR$CsrParams.getExt().get(n2 + 1));
            if (((String)createCSR$CsrParams.getExt().get(n2 + 2)).equals("1")) {
                stringBuilder.append(" [mandatory]\n");
                continue;
            }
            stringBuilder.append(" [optional]\n");
        }
        System.out.print(stringBuilder);
    }
}

