/*
 * Decompiled with CFR 0.152.
 */
package com.isbc.smartcard.esmarttoken.api;

import com.isbc.smartcard.esmarttoken.api.Pkcs11ObjectAttribute;
import com.isbc.smartcard.esmarttoken.api.Pkcs11Wrapper;
import com.isbc.smartcard.esmarttoken.utils.HexUtils;
import com.isbc.smartcard.esmarttoken.utils.TerminalUtils;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.smartcardio.Card;
import javax.smartcardio.CardTerminal;
import org.apache.log4j.Logger;

public class Console {
    private static Logger logger = Logger.getLogger(Console.class);
    private static final long SIGN_EXPIRED_CERT_ERROR = 0x80000600L;

    private Console() {
    }

    public static void main(String[] object) {
        Scanner scanner = new Scanner(System.in);
        System.out.println("This programm will perform some tests.\nThese tests erase all data on token/smart-card.\nContinue? [yes/no]: ");
        if (!scanner.nextLine().equalsIgnoreCase("yes")) {
            System.out.println("Abort.");
            return;
        }
        int n2 = 1;
        int n3 = 0;
        if (object != null && ((String[])object).length > 0) {
            n2 = Integer.valueOf(object[0]);
        }
        boolean bl2 = false;
        if (((String[])object).length > 0) {
            int n4 = ((String[])object).length;
            for (int i2 = 0; i2 < n4; ++i2) {
                if (object[i2].compareToIgnoreCase("--skip-init-token") != 0) continue;
                bl2 = true;
            }
        }
        logger.info("Start testing " + n2 + " time(s).");
        object = new Pkcs11Wrapper();
        String string = System.getProperty("os.name").toLowerCase();
        logger.info("OS name: " + string);
        String string2 = string.indexOf("windows") >= 0 ? "isbc_pkcs11_main.dll" : (string.indexOf("mac os") >= 0 ? "libisbc_pkcs11_main.dylib" : "libisbc_pkcs11_main.so");
        try {
            TerminalUtils.loadConfig("../conf/pkcs11.conf");
        }
        catch (IOException iOException) {
            logger.error("Failed to load config file", iOException);
        }
        CardTerminal cardTerminal = null;
        try {
            cardTerminal = TerminalUtils.getFirstValidTerminal();
            logger.info("Token UID: " + TerminalUtils.getCardUID(cardTerminal));
        }
        catch (Exception exception) {
            logger.error("Get UID error", exception);
        }
        long l2 = -1L;
        long l3 = System.currentTimeMillis();
        while (n2 > n3) {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            String string3;
            long l4;
            block110: {
                ArrayList<String> arrayList;
                Object object7;
                Object object8;
                block109: {
                    Object object9;
                    Object object10;
                    block106: {
                        block105: {
                            block104: {
                                block103: {
                                    block102: {
                                        l4 = System.currentTimeMillis();
                                        logger.info("Start attempt " + ++n3 + " of " + n2);
                                        if (!bl2) {
                                            logger.info("Trying to perform init token usign default pin");
                                            l2 = ((Pkcs11Wrapper)object).initCardWrap(null, string2, "12345678".getBytes());
                                            logger.info("initCardWrap result: " + l2);
                                            if (l2 != 0L) {
                                                logger.error("Stop checking because of error " + l2 + " on attempt " + n3 + " of " + n2);
                                                break;
                                            }
                                        } else {
                                            logger.info("Skip init token");
                                        }
                                        logger.info("Trying to load test certificate and private key from PKCS#12 file");
                                        try {
                                            FileInputStream fileInputStream = new FileInputStream("../conf/clientTest2.p12");
                                            object8 = new byte[fileInputStream.available()];
                                            fileInputStream.read((byte[])object8);
                                            fileInputStream.close();
                                            l2 = ((Pkcs11Wrapper)object).loadCertWrap(null, string2, (byte[])object8, "123".getBytes(), "12345678".getBytes());
                                            logger.info("loadCertWrap result: " + l2);
                                            if (l2 != 0L) {
                                                logger.error("Stop checking because of error " + l2 + " on attempt " + n3 + " of " + n2);
                                            }
                                            break block102;
                                        }
                                        catch (Exception exception) {
                                            logger.error("Read file error", exception);
                                            if (l2 == 0L) break block102;
                                            logger.error("Stop checking because of error " + exception.getMessage() + " on attempt " + n3 + " of " + n2);
                                        }
                                        break;
                                    }
                                    Card card = cardTerminal.connect("*");
                                    object8 = card;
                                    string3 = HexUtils.encodeHexString(card.getATR().getBytes());
                                    ((Card)object8).disconnect(true);
                                    if (TerminalUtils.getCardTypeByATR$3d702df3(string3) == p.g) {
                                        logger.info("Trying to load test GOST certificate and private key from PKCS#12 file");
                                        try {
                                            FileInputStream fileInputStream = new FileInputStream("../conf/clientGostA.p12");
                                            object8 = new byte[fileInputStream.available()];
                                            fileInputStream.read((byte[])object8);
                                            fileInputStream.close();
                                            l2 = ((Pkcs11Wrapper)object).loadCertWrap(null, string2, (byte[])object8, "123".getBytes(), "12345678".getBytes());
                                            logger.info("loadCertWrap result: " + l2);
                                            if (l2 != 0L) {
                                                logger.error("Stop checking GOST cert because of error " + l2 + " on attempt " + n3 + " of " + n2);
                                            }
                                            break block103;
                                        }
                                        catch (Exception exception) {
                                            logger.error("Read file error", exception);
                                            if (l2 == 0L) break block103;
                                            logger.error("Stop checking because of error " + exception.getMessage() + " on attempt " + n3 + " of " + n2);
                                        }
                                        break;
                                    }
                                }
                                logger.info("Trying to load test X509 certificate in DER format");
                                try {
                                    FileInputStream fileInputStream = new FileInputStream("../conf/ca.crt");
                                    object8 = new byte[fileInputStream.available()];
                                    fileInputStream.read((byte[])object8);
                                    fileInputStream.close();
                                    l2 = ((Pkcs11Wrapper)object).loadX509CertificateWrap(null, string2, "12345678".getBytes(), "newCAcert", HexUtils.decodeHex("1122334455"), (byte[])object8);
                                    logger.info("loadX509CertificateWrap result: " + l2);
                                    if (l2 != 0L) {
                                        logger.error("Stop checking because of error " + l2 + " on attempt " + n3 + " of " + n2);
                                    }
                                    break block104;
                                }
                                catch (Exception exception) {
                                    logger.error("Read file error", exception);
                                    if (l2 == 0L) break block104;
                                    logger.error("Stop checking because of error " + exception.getMessage() + " on attempt " + n3 + " of " + n2);
                                }
                                break;
                            }
                            if (TerminalUtils.getCardTypeByATR$3d702df3(string3) == p.g || TerminalUtils.getCardTypeByATR$3d702df3(string3) == p.h) {
                                logger.info("Trying to load test X509 GOST certificate in DER format");
                                try {
                                    FileInputStream fileInputStream = new FileInputStream("../conf/ca_gost.crt");
                                    object8 = new byte[fileInputStream.available()];
                                    fileInputStream.read((byte[])object8);
                                    fileInputStream.close();
                                    l2 = ((Pkcs11Wrapper)object).loadX509CertificateWrap(null, string2, "12345678".getBytes(), "newCA_GOSTcert", HexUtils.decodeHex("6677889900"), (byte[])object8);
                                    logger.info("loadX509CertificateWrap result: " + l2);
                                    if (l2 != 0L) {
                                        logger.error("Stop checking because of error " + l2 + " on attempt " + n3 + " of " + n2);
                                    }
                                    break block105;
                                }
                                catch (Exception exception) {
                                    logger.error("Read file error", exception);
                                    if (l2 == 0L) break block105;
                                    logger.error("Stop checking because of error " + exception.getMessage() + " on attempt " + n3 + " of " + n2);
                                }
                                break;
                            }
                        }
                        logger.info("Try to generate RSA 1024 key pair");
                        l2 = ((Pkcs11Wrapper)object).generateKeyPairWrap(null, string2, "12345678".getBytes(), 1024L, "new1024key", HexUtils.decodeHex("1024"));
                        logger.info("generateKeyPairWrap result: " + l2);
                        if (l2 != 0L) {
                            logger.error("Stop checking because of error " + l2 + " on attempt " + n3 + " of " + n2);
                            break;
                        }
                        if (TerminalUtils.getCardTypeByATR$3d702df3(string3) != p.g && TerminalUtils.getCardTypeByATR$3d702df3(string3) != p.h) {
                            logger.info("Try to generate RSA 2048 key pair");
                            l2 = ((Pkcs11Wrapper)object).generateKeyPairWrap(null, string2, "12345678".getBytes(), 2048L, "new2048key", HexUtils.decodeHex("2048"));
                            logger.info("generateKeyPairWrap result: " + l2);
                            if (l2 != 0L) {
                                logger.error("Stop checking because of error " + l2 + " on attempt " + n3 + " of " + n2);
                                break;
                            }
                        } else {
                            logger.info("Try to generate GOST key pair");
                            l2 = ((Pkcs11Wrapper)object).generateGostR3410_2001KeyPairWrap(null, string2, "12345678".getBytes(), "newGOSTkey", HexUtils.decodeHex("0256"));
                            logger.info("generateGostR3410_2001KeyPairWrap result: " + l2);
                            if (l2 != 0L) {
                                logger.error("Stop checking because of error " + l2 + " on attempt " + n3 + " of " + n2);
                                break;
                            }
                        }
                        object8 = new ArrayList();
                        logger.info("Token objects enumeration");
                        l2 = ((Pkcs11Wrapper)object).listObjectsWrap(null, string2, "12345678".getBytes(), (List)object8);
                        Object object11 = null;
                        object7 = null;
                        object6 = null;
                        object5 = null;
                        arrayList = null;
                        object4 = null;
                        object3 = null;
                        object10 = null;
                        object9 = null;
                        for (int i3 = 0; i3 < object8.size(); ++i3) {
                            object2 = (Pkcs11ObjectAttribute)object8.get(i3);
                            logger.info("Type: " + ((Pkcs11ObjectAttribute)object2).getType());
                            logger.info("Label: " + ((Pkcs11ObjectAttribute)object2).getLabel());
                            logger.info("ID: " + ((Pkcs11ObjectAttribute)object2).getId());
                            logger.info("KeyType: " + ((Pkcs11ObjectAttribute)object2).getKeyType());
                            if (((Pkcs11ObjectAttribute)object2).getType().equals("certificate")) {
                                object11 = object2;
                                if (((Pkcs11ObjectAttribute)object2).getLabel().indexOf("Import") >= 0 && ((Pkcs11ObjectAttribute)object2).getId().equals(object10)) {
                                    object6 = object2;
                                    continue;
                                }
                                if (((Pkcs11ObjectAttribute)object2).getLabel().indexOf("Import") < 0 || !((Pkcs11ObjectAttribute)object2).getId().equals(object9)) continue;
                                object4 = object2;
                                continue;
                            }
                            if (((Pkcs11ObjectAttribute)object2).getType().equals("public key")) {
                                if (((Pkcs11ObjectAttribute)object2).getKeyType() != null && ((Pkcs11ObjectAttribute)object2).getKeyType().equals("RSA")) {
                                    object7 = object2;
                                    continue;
                                }
                                if (((Pkcs11ObjectAttribute)object2).getKeyType() == null || !((Pkcs11ObjectAttribute)object2).getKeyType().equals("GOSTR3410")) continue;
                                arrayList = object2;
                                continue;
                            }
                            if (!((Pkcs11ObjectAttribute)object2).getType().equals("private key") || ((Pkcs11ObjectAttribute)object2).getLabel().indexOf("Import") < 0) continue;
                            if (((Pkcs11ObjectAttribute)object2).getKeyType() != null && ((Pkcs11ObjectAttribute)object2).getKeyType().equals("RSA")) {
                                object5 = object2;
                                object10 = ((Pkcs11ObjectAttribute)object2).getId();
                                continue;
                            }
                            if (((Pkcs11ObjectAttribute)object2).getKeyType() == null || !((Pkcs11ObjectAttribute)object2).getKeyType().equals("GOSTR3410")) continue;
                            object3 = object2;
                            object9 = ((Pkcs11ObjectAttribute)object2).getId();
                        }
                        logger.info("listObjects result: " + l2);
                        if (l2 != 0L) {
                            logger.error("Stop checking because of error " + l2 + " on attempt " + n3 + " of " + n2);
                            break;
                        }
                        if (object11 != null) {
                            logger.info("Trying to get certificate: " + ((Pkcs11ObjectAttribute)object11).getLabel() + " with id " + ((Pkcs11ObjectAttribute)object11).getId());
                            ArrayList arrayList2 = new ArrayList();
                            l2 = ((Pkcs11Wrapper)object).getX509CertificateWrap(null, string2, "12345678".getBytes(), ((Pkcs11ObjectAttribute)object11).getLabel(), HexUtils.decodeHex(((Pkcs11ObjectAttribute)object11).getId()), arrayList2);
                            logger.info("getX509CertificateWrap result: " + l2 + " buffer size: " + arrayList2.size());
                            if (l2 != 0L) {
                                logger.error("Stop checking because of error " + l2 + " on attempt " + n3 + " of " + n2);
                                break;
                            }
                            if (!arrayList2.isEmpty()) {
                                try {
                                    object2 = new FileOutputStream("testcert.cer");
                                    for (int i4 = 0; i4 < arrayList2.size(); ++i4) {
                                        ((FileOutputStream)object2).write(((Byte)arrayList2.get(i4)).byteValue());
                                    }
                                    ((FileOutputStream)object2).close();
                                    logger.info("Certificate saved to testcert.cer");
                                }
                                catch (Exception exception) {
                                    logger.error("Write file error", exception);
                                    if (l2 == 0L) break block106;
                                    logger.error("Stop checking because of error " + exception.getMessage() + " on attempt " + n3 + " of " + n2);
                                    break;
                                }
                            }
                        }
                    }
                    if (object7 != null) {
                        block108: {
                            logger.info("Trying to get public key: " + ((Pkcs11ObjectAttribute)object7).getLabel() + " with id " + ((Pkcs11ObjectAttribute)object7).getId());
                            ArrayList arrayList3 = new ArrayList();
                            object2 = new ArrayList();
                            l2 = ((Pkcs11Wrapper)object).getPublicKeyWrap(null, string2, "12345678".getBytes(), ((Pkcs11ObjectAttribute)object7).getLabel(), HexUtils.decodeHex(((Pkcs11ObjectAttribute)object7).getId()), arrayList3, (List)object2);
                            logger.info("getPublicKeyWrap result: " + l2 + " modulusData size: " + arrayList3.size() + " exponentData size: " + object2.size());
                            if (l2 != 0L) {
                                logger.error("Stop checking because of error " + l2 + " on attempt " + n3 + " of " + n2);
                                break;
                            }
                            if (!arrayList3.isEmpty()) {
                                block107: {
                                    try {
                                        FileOutputStream fileOutputStream = new FileOutputStream("modulus.data");
                                        for (int i5 = 0; i5 < arrayList3.size(); ++i5) {
                                            fileOutputStream.write(((Byte)arrayList3.get(i5)).byteValue());
                                        }
                                        fileOutputStream.close();
                                        logger.info("modulusData saved to modulus.data");
                                    }
                                    catch (Exception exception) {
                                        logger.error("Write file error", exception);
                                        if (l2 == 0L) break block107;
                                        logger.error("Stop checking because of error " + exception.getMessage() + " on attempt " + n3 + " of " + n2);
                                        break;
                                    }
                                }
                                try {
                                    FileOutputStream fileOutputStream = new FileOutputStream("exponent.data");
                                    for (int i6 = 0; i6 < object2.size(); ++i6) {
                                        fileOutputStream.write(((Byte)object2.get(i6)).byteValue());
                                    }
                                    fileOutputStream.close();
                                    logger.info("exponentData saved to exponent.data");
                                }
                                catch (Exception exception) {
                                    logger.error("Write file error", exception);
                                    if (l2 == 0L) break block108;
                                    logger.error("Stop checking because of error " + exception.getMessage() + " on attempt " + n3 + " of " + n2);
                                    break;
                                }
                            }
                        }
                        logger.info("Trying to create CSR for: " + ((Pkcs11ObjectAttribute)object7).getLabel() + " with id " + ((Pkcs11ObjectAttribute)object7).getId());
                        ArrayList arrayList4 = new ArrayList();
                        object8 = new ArrayList<String>();
                        object8.add("CN");
                        object8.add("Ivan Ivanov");
                        object8.add("emailAddress");
                        object8.add("ivanov@mail.ru");
                        object10 = new ArrayList<String>();
                        object10.add("challengePassword");
                        object10.add("123");
                        object9 = new ArrayList<String>();
                        object9.add("keyUsage");
                        object9.add("digitalSignature,keyEncipherment");
                        object9.add("1");
                        object9.add("subjectAltName");
                        object9.add("DNS:isbc.ru");
                        object9.add("1");
                        object9.add("extendedKeyUsage");
                        object9.add("1.3.6.1.4.1.311.20.2.2");
                        object9.add("0");
                        l2 = ((Pkcs11Wrapper)object).createCSRWrap(null, string2, "12345678".getBytes(), HexUtils.decodeHex(((Pkcs11ObjectAttribute)object7).getId()), HexUtils.decodeHex(((Pkcs11ObjectAttribute)object7).getId()), object8.toArray(new String[0]), object10.toArray(new String[0]), object9.toArray(new String[0]), arrayList4);
                        logger.info("createCSRWrap result: " + l2 + " buffer size: " + arrayList4.size());
                        if (l2 != 0L) {
                            logger.error("Stop checking because of error " + l2 + " on attempt " + n3 + " of " + n2);
                            break;
                        }
                        if (!arrayList4.isEmpty()) {
                            try {
                                object8 = new FileOutputStream("testcsr.csr");
                                for (int i7 = 0; i7 < arrayList4.size(); ++i7) {
                                    ((FileOutputStream)object8).write(((Byte)arrayList4.get(i7)).byteValue());
                                }
                                ((FileOutputStream)object8).close();
                                logger.info("CSR saved to test.csr");
                            }
                            catch (Exception exception) {
                                logger.error("Write file error", exception);
                                if (l2 == 0L) break block109;
                                logger.error("Stop checking because of error " + exception.getMessage() + " on attempt " + n3 + " of " + n2);
                                break;
                            }
                        }
                    }
                }
                if (arrayList != null && (TerminalUtils.getCardTypeByATR$3d702df3(string3) == p.g || TerminalUtils.getCardTypeByATR$3d702df3(string3) == p.h)) {
                    logger.info("Trying to create GOST CSR for: " + ((Pkcs11ObjectAttribute)object7).getLabel() + " with id " + ((Pkcs11ObjectAttribute)object7).getId());
                    ArrayList arrayList5 = new ArrayList();
                    object2 = new ArrayList<String>();
                    object2.add("CN");
                    object2.add("Ivan Ivanov GOST");
                    object2.add("emailAddress");
                    object2.add("ivanov@mail.ru");
                    ArrayList<String> arrayList6 = new ArrayList<String>();
                    arrayList6.add("challengePassword");
                    arrayList6.add("123");
                    object8 = new ArrayList<String>();
                    object8.add("keyUsage");
                    object8.add("digitalSignature,keyEncipherment");
                    object8.add("1");
                    object8.add("subjectAltName");
                    object8.add("DNS:isbc.ru");
                    object8.add("1");
                    object8.add("extendedKeyUsage");
                    object8.add("1.3.6.1.4.1.311.20.2.2");
                    object8.add("0");
                    l2 = ((Pkcs11Wrapper)object).createCSRWrap(null, string2, "12345678".getBytes(), HexUtils.decodeHex(((Pkcs11ObjectAttribute)((Object)arrayList)).getId()), HexUtils.decodeHex(((Pkcs11ObjectAttribute)((Object)arrayList)).getId()), object2.toArray(new String[0]), arrayList6.toArray(new String[0]), object8.toArray(new String[0]), arrayList5);
                    logger.info("createCSRWrap result: " + l2 + " buffer size: " + arrayList5.size());
                    if (l2 != 0L) {
                        logger.error("Stop checking because of error " + l2 + " on attempt " + n3 + " of " + n2);
                        break;
                    }
                    if (!arrayList5.isEmpty()) {
                        try {
                            FileOutputStream fileOutputStream = new FileOutputStream("testcsr_gost.csr");
                            for (int i8 = 0; i8 < arrayList5.size(); ++i8) {
                                fileOutputStream.write(((Byte)arrayList5.get(i8)).byteValue());
                            }
                            fileOutputStream.close();
                            logger.info("CSR saved to testcsr_gost.csr");
                        }
                        catch (Exception exception) {
                            logger.error("Write file error", exception);
                            if (l2 == 0L) break block110;
                            logger.error("Stop checking because of error " + exception.getMessage() + " on attempt " + n3 + " of " + n2);
                            break;
                        }
                    }
                }
            }
            if (object5 != null && object6 != null) {
                ArrayList arrayList;
                block112: {
                    block111: {
                        logger.info("Trying to sign data in PKCS#7 format");
                        arrayList = new ArrayList();
                        l2 = ((Pkcs11Wrapper)object).pkcs7SignWrap(null, string2, "12345678".getBytes(), "SIGNDATA".getBytes(), HexUtils.decodeHex(((Pkcs11ObjectAttribute)object5).getId()), HexUtils.decodeHex(((Pkcs11ObjectAttribute)object6).getId()), null, 0L, arrayList);
                        if (l2 == 0x80000600L) {
                            logger.info("pkcs7SignWrap certificate has expired and can't be used for sign");
                        } else {
                            logger.info("pkcs7SignWrap result: " + l2 + " buffer size: " + arrayList.size());
                        }
                        if (l2 != 0L) {
                            logger.error("Stop checking because of error " + l2 + " on attempt " + n3 + " of " + n2);
                            break;
                        }
                        if (!arrayList.isEmpty()) {
                            try {
                                object2 = new FileOutputStream("signedData.p7");
                                for (int i9 = 0; i9 < arrayList.size(); ++i9) {
                                    ((FileOutputStream)object2).write(((Byte)arrayList.get(i9)).byteValue());
                                }
                                ((FileOutputStream)object2).close();
                                logger.info("Signed data saved to signedData.p7");
                            }
                            catch (Exception exception) {
                                logger.error("Write file error", exception);
                                if (l2 == 0L) break block111;
                                logger.error("Stop checking because of error " + exception.getMessage() + " on attempt " + n3 + " of " + n2);
                                break;
                            }
                        }
                    }
                    logger.info("Trying to verify data in PKCS#7 format");
                    object2 = new byte[arrayList.size()];
                    for (int i10 = 0; i10 < arrayList.size(); ++i10) {
                        object2[i10] = (Byte)arrayList.get(i10);
                    }
                    l2 = ((Pkcs11Wrapper)object).pkcs7VerifyWrap(string2, (byte[])object2, null);
                    logger.info("pkcs7VerifyWrap result: " + l2);
                    logger.info("Trying to sign data in PKCS#7 format detached");
                    arrayList = new ArrayList();
                    l2 = ((Pkcs11Wrapper)object).pkcs7SignWrap(null, string2, "12345678".getBytes(), "SIGNDATA".getBytes(), HexUtils.decodeHex(((Pkcs11ObjectAttribute)object5).getId()), HexUtils.decodeHex(((Pkcs11ObjectAttribute)object6).getId()), null, 64L, arrayList);
                    if (l2 == 0x80000600L) {
                        logger.info("pkcs7SignWrap certificate has expired and can't be used for sign");
                    } else {
                        logger.info("pkcs7SignWrap result: " + l2 + " buffer size: " + arrayList.size());
                    }
                    if (l2 != 0L) {
                        logger.error("Stop checking because of error " + l2 + " on attempt " + n3 + " of " + n2);
                        break;
                    }
                    if (!arrayList.isEmpty()) {
                        try {
                            FileOutputStream fileOutputStream = new FileOutputStream("signedData2.p7");
                            for (int i11 = 0; i11 < arrayList.size(); ++i11) {
                                fileOutputStream.write(((Byte)arrayList.get(i11)).byteValue());
                            }
                            fileOutputStream.close();
                            logger.info("Signed data saved to signedData2.p7");
                        }
                        catch (Exception exception) {
                            logger.error("Write file error", exception);
                            if (l2 == 0L) break block112;
                            logger.error("Stop checking because of error " + exception.getMessage() + " on attempt " + n3 + " of " + n2);
                            break;
                        }
                    }
                }
                logger.info("Trying to verify data in PKCS#7 format detached");
                object2 = new byte[arrayList.size()];
                for (int i12 = 0; i12 < arrayList.size(); ++i12) {
                    object2[i12] = (Byte)arrayList.get(i12);
                }
                l2 = ((Pkcs11Wrapper)object).pkcs7VerifyWrap(string2, (byte[])object2, "SIGNDATA".getBytes());
                logger.info("pkcs7VerifyWrap result: " + l2);
            }
            if (object3 != null && object4 != null && (TerminalUtils.getCardTypeByATR$3d702df3(string3) == p.g || TerminalUtils.getCardTypeByATR$3d702df3(string3) == p.h)) {
                ArrayList arrayList;
                block114: {
                    block113: {
                        logger.info("Trying to sign data in PKCS#7 format GOST cert");
                        arrayList = new ArrayList();
                        l2 = ((Pkcs11Wrapper)object).pkcs7SignWrap(null, string2, "12345678".getBytes(), "SIGNDATA-GOST".getBytes(), HexUtils.decodeHex(((Pkcs11ObjectAttribute)object3).getId()), HexUtils.decodeHex(((Pkcs11ObjectAttribute)object4).getId()), null, 0L, arrayList);
                        if (l2 == 0x80000600L) {
                            logger.info("pkcs7SignWrap certificate has expired and can't be used for sign");
                        } else {
                            logger.info("pkcs7SignWrap result: " + l2 + " buffer size: " + arrayList.size());
                        }
                        if (l2 != 0L) {
                            logger.error("Stop checking because of error " + l2 + " on attempt " + n3 + " of " + n2);
                            break;
                        }
                        if (!arrayList.isEmpty()) {
                            try {
                                object2 = new FileOutputStream("signedData_gost.p7");
                                for (int i13 = 0; i13 < arrayList.size(); ++i13) {
                                    ((FileOutputStream)object2).write(((Byte)arrayList.get(i13)).byteValue());
                                }
                                ((FileOutputStream)object2).close();
                                logger.info("Signed data saved to signedData_gost.p7");
                            }
                            catch (Exception exception) {
                                logger.error("Write file error", exception);
                                if (l2 == 0L) break block113;
                                logger.error("Stop checking because of error " + exception.getMessage() + " on attempt " + n3 + " of " + n2);
                                break;
                            }
                        }
                    }
                    logger.info("Trying to verify data in PKCS#7 format GOST");
                    object2 = new byte[arrayList.size()];
                    for (int i14 = 0; i14 < arrayList.size(); ++i14) {
                        object2[i14] = (Byte)arrayList.get(i14);
                    }
                    l2 = ((Pkcs11Wrapper)object).pkcs7VerifyWrap(string2, (byte[])object2, null);
                    logger.info("pkcs7VerifyWrap result: " + l2);
                    logger.info("Trying to sign data in PKCS#7 format detached GOST");
                    arrayList = new ArrayList();
                    l2 = ((Pkcs11Wrapper)object).pkcs7SignWrap(null, string2, "12345678".getBytes(), "SIGNDATA-GOST".getBytes(), HexUtils.decodeHex(((Pkcs11ObjectAttribute)object3).getId()), HexUtils.decodeHex(((Pkcs11ObjectAttribute)object4).getId()), null, 64L, arrayList);
                    if (l2 == 0x80000600L) {
                        logger.error("pkcs7SignWrap certificate has expired and can't be used for sign");
                    } else {
                        logger.info("pkcs7SignWrap result: " + l2 + " buffer size: " + arrayList.size());
                    }
                    if (l2 != 0L) {
                        logger.error("Stop checking because of error " + l2 + " on attempt " + n3 + " of " + n2);
                        break;
                    }
                    if (!arrayList.isEmpty()) {
                        try {
                            FileOutputStream fileOutputStream = new FileOutputStream("signedData2_gost.p7");
                            for (int i15 = 0; i15 < arrayList.size(); ++i15) {
                                fileOutputStream.write(((Byte)arrayList.get(i15)).byteValue());
                            }
                            fileOutputStream.close();
                            logger.info("Signed data saved to signedData2_gost.p7");
                        }
                        catch (Exception exception) {
                            logger.error("Write file error", exception);
                            if (l2 == 0L) break block114;
                            logger.error("Stop checking because of error " + exception.getMessage() + " on attempt " + n3 + " of " + n2);
                            break;
                        }
                    }
                }
                logger.info("Trying to verify data in PKCS#7 format detached GOST");
                object2 = new byte[arrayList.size()];
                for (int i16 = 0; i16 < arrayList.size(); ++i16) {
                    object2[i16] = (Byte)arrayList.get(i16);
                }
                l2 = ((Pkcs11Wrapper)object).pkcs7VerifyWrap(string2, (byte[])object2, "SIGNDATA-GOST".getBytes());
                logger.info("pkcs7VerifyWrap result: " + l2);
            }
            logger.info("Try to change PIN");
            l2 = ((Pkcs11Wrapper)object).setPinWrap(null, string2, "12345678".getBytes(), "11111111".getBytes());
            logger.info("setPinWrap result: " + l2);
            if (l2 != 0L) {
                logger.error("Stop checking because of error " + l2 + " on attempt " + n3 + " of " + n2);
                break;
            }
            logger.info("Try to change PIN back to default");
            l2 = ((Pkcs11Wrapper)object).setPinWrap(null, string2, "11111111".getBytes(), "12345678".getBytes());
            logger.info("setPinWrap result: " + l2);
            if (l2 != 0L) {
                logger.error("Stop checking because of error " + l2 + " on attempt " + n3 + " of " + n2);
                break;
            }
            logger.info("Try to change PUK");
            l2 = ((Pkcs11Wrapper)object).setPukWrap(null, string2, "12345678".getBytes(), "11111111".getBytes());
            logger.info("setPukWrap result: " + l2);
            if (l2 != 0L) {
                logger.error("Stop checking because of error " + l2 + " on attempt " + n3 + " of " + n2);
                break;
            }
            logger.info("Try to change PUK back to default");
            l2 = ((Pkcs11Wrapper)object).setPukWrap(null, string2, "11111111".getBytes(), "12345678".getBytes());
            logger.info("setPukWrap result: " + l2);
            logger.info("Cleaning card");
            l2 = ((Pkcs11Wrapper)object).cleanCardWrap(null, string2, "12345678".getBytes());
            logger.info("cleanCardWrap result: " + l2);
            if (l2 != 0L) {
                logger.error("Stop checking because of error " + l2 + " on attempt " + n3 + " of " + n2);
                break;
            }
            logger.info("End attempt " + n3 + " of " + n2 + ". Duration " + (int)(System.currentTimeMillis() - l4) / 1000 + " seconds.");
            logger.info("======================================================================================");
            logger.info("======================================================================================");
        }
        logger.info("End cheking. " + n3 + " were perfomed for " + (int)(System.currentTimeMillis() - l3) / 1000 + " seconds.");
    }
}

