/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class DailyRollingFileAppender
extends FileAppender {
    static final int TOP_OF_TROUBLE = -1;
    static final int TOP_OF_MINUTE = 0;
    static final int TOP_OF_HOUR = 1;
    static final int HALF_DAY = 2;
    static final int TOP_OF_DAY = 3;
    static final int TOP_OF_WEEK = 4;
    static final int TOP_OF_MONTH = 5;
    private String datePattern = "'.'yyyy-MM-dd";
    private String scheduledFilename;
    private long nextCheck = System.currentTimeMillis() - 1L;
    Date now = new Date();
    SimpleDateFormat sdf;
    E rc = new E();
    int checkPeriod = -1;
    static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");

    public DailyRollingFileAppender() {
    }

    public DailyRollingFileAppender(Layout layout, String string, String string2) {
        super(layout, string, true);
        this.datePattern = string2;
        this.activateOptions();
    }

    public void setDatePattern(String string) {
        this.datePattern = string;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void activateOptions() {
        super.activateOptions();
        if (this.datePattern != null && this.fileName != null) {
            this.now.setTime(System.currentTimeMillis());
            this.sdf = new SimpleDateFormat(this.datePattern);
            int n2 = this.computeCheckPeriod();
            this.printPeriodicity(n2);
            this.rc.a = n2;
            File file = new File(this.fileName);
            this.scheduledFilename = this.fileName + this.sdf.format(new Date(file.lastModified()));
            return;
        }
        LogLog.error("Either File or DatePattern options are not set for appender [" + this.name + "].");
    }

    void printPeriodicity(int n2) {
        switch (n2) {
            case 0: {
                LogLog.debug("Appender [" + this.name + "] to be rolled every minute.");
                return;
            }
            case 1: {
                LogLog.debug("Appender [" + this.name + "] to be rolled on top of every hour.");
                return;
            }
            case 2: {
                LogLog.debug("Appender [" + this.name + "] to be rolled at midday and midnight.");
                return;
            }
            case 3: {
                LogLog.debug("Appender [" + this.name + "] to be rolled at midnight.");
                return;
            }
            case 4: {
                LogLog.debug("Appender [" + this.name + "] to be rolled at start of week.");
                return;
            }
            case 5: {
                LogLog.debug("Appender [" + this.name + "] to be rolled at start of every month.");
                return;
            }
        }
        LogLog.warn("Unknown periodicity for appender [" + this.name + "].");
    }

    int computeCheckPeriod() {
        E e2 = new E(gmtTimeZone, Locale.ENGLISH);
        Date date = new Date(0L);
        if (this.datePattern != null) {
            int n2 = 0;
            while (n2 <= 5) {
                Object object = new SimpleDateFormat(this.datePattern);
                ((DateFormat)object).setTimeZone(gmtTimeZone);
                String string = ((DateFormat)object).format(date);
                e2.a = n2;
                Date date2 = new Date(e2.a(date));
                object = ((DateFormat)object).format(date2);
                if (string != null && object != null && !string.equals(object)) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    void rollOver() {
        if (this.datePattern == null) {
            this.errorHandler.error("Missing DatePattern option in rollOver().");
            return;
        }
        String string = this.fileName + this.sdf.format(this.now);
        if (this.scheduledFilename.equals(string)) {
            return;
        }
        this.closeFile();
        File file = new File(this.scheduledFilename);
        if (file.exists()) {
            file.delete();
        }
        if (new File(this.fileName).renameTo(file)) {
            LogLog.debug(this.fileName + " -> " + this.scheduledFilename);
        } else {
            LogLog.error("Failed to rename [" + this.fileName + "] to [" + this.scheduledFilename + "].");
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException iOException) {
            this.errorHandler.error("setFile(" + this.fileName + ", false) call failed.");
        }
        this.scheduledFilename = string;
    }

    protected void subAppend(LoggingEvent loggingEvent) {
        long l2 = System.currentTimeMillis();
        if (l2 >= this.nextCheck) {
            this.now.setTime(l2);
            this.nextCheck = this.rc.a(this.now);
            try {
                this.rollOver();
            }
            catch (IOException iOException) {
                LogLog.error("rollOver() failed.", iOException);
            }
        }
        super.subAppend(loggingEvent);
    }
}

