/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import org.apache.log4j.Layout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.QuietWriter;

public class FileAppender
extends WriterAppender {
    protected boolean fileAppend = true;
    protected String fileName = null;
    protected boolean bufferedIO = false;
    protected int bufferSize = 8192;

    public FileAppender() {
    }

    public FileAppender(Layout layout, String string, boolean bl2, boolean bl3, int n2) {
        this.layout = layout;
        this.setFile(string, bl2, bl3, n2);
    }

    public FileAppender(Layout layout, String string, boolean bl2) {
        this.layout = layout;
        this.setFile(string, bl2, false, this.bufferSize);
    }

    public FileAppender(Layout layout, String string) {
        this(layout, string, true);
    }

    public void setFile(String string) {
        this.fileName = string = string.trim();
    }

    public boolean getAppend() {
        return this.fileAppend;
    }

    public String getFile() {
        return this.fileName;
    }

    public void activateOptions() {
        if (this.fileName != null) {
            try {
                this.setFile(this.fileName, this.fileAppend, this.bufferedIO, this.bufferSize);
                return;
            }
            catch (IOException iOException) {
                this.errorHandler.error("setFile(" + this.fileName + "," + this.fileAppend + ") call failed.", iOException, 4);
                return;
            }
        }
        LogLog.warn("File option not set for appender [" + this.name + "].");
        LogLog.warn("Are you using FileAppender instead of ConsoleAppender?");
    }

    protected void closeFile() {
        if (this.qw != null) {
            try {
                this.qw.close();
                return;
            }
            catch (IOException iOException) {
                LogLog.error("Could not close " + this.qw, iOException);
            }
        }
    }

    public boolean getBufferedIO() {
        return this.bufferedIO;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setAppend(boolean bl2) {
        this.fileAppend = bl2;
    }

    public void setBufferedIO(boolean bl2) {
        this.bufferedIO = bl2;
        if (bl2) {
            this.immediateFlush = false;
        }
    }

    public void setBufferSize(int n2) {
        this.bufferSize = n2;
    }

    public synchronized void setFile(String string, boolean bl2, boolean bl3, int n2) {
        LogLog.debug("setFile called: " + string + ", " + bl2);
        if (bl3) {
            this.setImmediateFlush(false);
        }
        this.reset();
        Writer writer = this.createWriter(new FileOutputStream(string, bl2));
        if (bl3) {
            writer = new BufferedWriter(writer, n2);
        }
        this.setQWForFiles(writer);
        this.fileName = string;
        this.fileAppend = bl2;
        this.bufferedIO = bl3;
        this.bufferSize = n2;
        this.writeHeader();
        LogLog.debug("setFile ended");
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new QuietWriter(writer, this.errorHandler);
    }

    protected void reset() {
        this.closeFile();
        this.fileName = null;
        super.reset();
    }
}

