/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.or.ObjectRenderer;
import org.apache.log4j.or.RendererMap;
import org.apache.log4j.spi.HierarchyEventListener;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RendererSupport;

public class Hierarchy
implements LoggerRepository,
RendererSupport {
    private LoggerFactory defaultFactory;
    private Vector listeners;
    Hashtable ht = new Hashtable();
    Logger root;
    RendererMap rendererMap;
    int thresholdInt;
    Level threshold;
    boolean emittedNoAppenderWarning = false;
    boolean emittedNoResourceBundleWarning = false;

    public Hierarchy(Logger logger) {
        this.listeners = new Vector(1);
        this.root = logger;
        this.setThreshold(Level.ALL);
        this.root.setHierarchy(this);
        this.rendererMap = new RendererMap();
        this.defaultFactory = new z();
    }

    public void addRenderer(Class clazz, ObjectRenderer objectRenderer) {
        this.rendererMap.put(clazz, objectRenderer);
    }

    public void addHierarchyEventListener(HierarchyEventListener hierarchyEventListener) {
        if (this.listeners.contains(hierarchyEventListener)) {
            LogLog.warn("Ignoring attempt to add an existent listener.");
            return;
        }
        this.listeners.addElement(hierarchyEventListener);
    }

    public void clear() {
        this.ht.clear();
    }

    public void emitNoAppenderWarning(Category category) {
        if (!this.emittedNoAppenderWarning) {
            LogLog.warn("No appenders could be found for logger (" + category.getName() + ").");
            LogLog.warn("Please initialize the log4j system properly.");
            this.emittedNoAppenderWarning = true;
        }
    }

    public Logger exists(String string) {
        if ((string = this.ht.get(new y(string))) instanceof Logger) {
            return (Logger)((Object)string);
        }
        return null;
    }

    public void setThreshold(String string) {
        Level level = Level.toLevel(string, null);
        if (level != null) {
            this.setThreshold(level);
            return;
        }
        LogLog.warn("Could not convert [" + string + "] to Level.");
    }

    public void setThreshold(Level level) {
        if (level != null) {
            this.thresholdInt = level.level;
            this.threshold = level;
        }
    }

    public void fireAddAppenderEvent(Category category, Appender appender) {
        if (this.listeners != null) {
            int n2 = this.listeners.size();
            int n3 = 0;
            while (n3 < n2) {
                ((HierarchyEventListener)this.listeners.elementAt(n3)).addAppenderEvent(category, appender);
                ++n3;
            }
        }
    }

    void fireRemoveAppenderEvent(Category category, Appender appender) {
        if (this.listeners != null) {
            int n2 = this.listeners.size();
            int n3 = 0;
            while (n3 < n2) {
                ((HierarchyEventListener)this.listeners.elementAt(n3)).removeAppenderEvent(category, appender);
                ++n3;
            }
        }
    }

    public Level getThreshold() {
        return this.threshold;
    }

    public Logger getLogger(String string) {
        return this.getLogger(string, this.defaultFactory);
    }

    public Logger getLogger(String object, LoggerFactory loggerFactory) {
        y y2 = new y((String)object);
        Hashtable hashtable = this.ht;
        synchronized (hashtable) {
            Object v2 = this.ht.get(y2);
            if (v2 == null) {
                object = loggerFactory.makeNewLoggerInstance((String)object);
                ((Category)object).setHierarchy(this);
                this.ht.put(y2, object);
                this.updateParents((Logger)object);
                return object;
            }
            if (v2 instanceof Logger) {
                object = (Logger)v2;
                return object;
            }
            if (v2 instanceof D) {
                object = loggerFactory.makeNewLoggerInstance((String)object);
                ((Category)object).setHierarchy(this);
                this.ht.put(y2, object);
                this.updateChildren((D)v2, (Logger)object);
                this.updateParents((Logger)object);
                return object;
            }
            return null;
        }
    }

    public Enumeration getCurrentLoggers() {
        Vector vector = new Vector(this.ht.size());
        Enumeration enumeration = this.ht.elements();
        while (enumeration.hasMoreElements()) {
            Object v2 = enumeration.nextElement();
            if (!(v2 instanceof Logger)) continue;
            vector.addElement(v2);
        }
        return vector.elements();
    }

    public Enumeration getCurrentCategories() {
        return this.getCurrentLoggers();
    }

    public RendererMap getRendererMap() {
        return this.rendererMap;
    }

    public Logger getRootLogger() {
        return this.root;
    }

    public boolean isDisabled(int n2) {
        return this.thresholdInt > n2;
    }

    public void overrideAsNeeded(String string) {
        LogLog.warn("The Hiearchy.overrideAsNeeded method has been deprecated.");
    }

    public void resetConfiguration() {
        this.getRootLogger().setLevel(Level.DEBUG);
        this.root.setResourceBundle(null);
        this.setThreshold(Level.ALL);
        Hashtable hashtable = this.ht;
        synchronized (hashtable) {
            this.shutdown();
            Enumeration enumeration = this.getCurrentLoggers();
            while (enumeration.hasMoreElements()) {
                Logger logger = (Logger)enumeration.nextElement();
                logger.setLevel(null);
                logger.setAdditivity(true);
                logger.setResourceBundle(null);
            }
        }
        this.rendererMap.clear();
    }

    public void setDisableOverride(String string) {
        LogLog.warn("The Hiearchy.setDisableOverride method has been deprecated.");
    }

    public void setRenderer(Class clazz, ObjectRenderer objectRenderer) {
        this.rendererMap.put(clazz, objectRenderer);
    }

    public void shutdown() {
        Logger logger = this.getRootLogger();
        logger.closeNestedAppenders();
        Hashtable hashtable = this.ht;
        synchronized (hashtable) {
            Enumeration enumeration = this.getCurrentLoggers();
            while (enumeration.hasMoreElements()) {
                ((Logger)enumeration.nextElement()).closeNestedAppenders();
            }
            logger.removeAllAppenders();
            enumeration = this.getCurrentLoggers();
            while (enumeration.hasMoreElements()) {
                ((Logger)enumeration.nextElement()).removeAllAppenders();
            }
            return;
        }
    }

    private final void updateParents(Logger logger) {
        String string = logger.name;
        int n2 = string.length();
        boolean bl2 = false;
        while ((n2 = string.lastIndexOf(46, n2 - 1)) >= 0) {
            Object object = string.substring(0, n2);
            Object object2 = this.ht.get(object = new y((String)object));
            if (object2 == null) {
                object2 = new D(logger);
                this.ht.put(object, object2);
                continue;
            }
            if (object2 instanceof Category) {
                bl2 = true;
                logger.parent = (Category)object2;
                break;
            }
            if (object2 instanceof D) {
                ((D)object2).addElement(logger);
                continue;
            }
            new IllegalStateException("unexpected object type " + object2.getClass() + " in ht.").printStackTrace();
        }
        if (!bl2) {
            logger.parent = this.root;
        }
    }

    private final void updateChildren(D d2, Logger logger) {
        int n2 = d2.size();
        int n3 = 0;
        while (n3 < n2) {
            Logger logger2 = (Logger)d2.elementAt(n3);
            if (!logger2.parent.name.startsWith(logger.name)) {
                logger.parent = logger2.parent;
                logger2.parent = logger;
            }
            ++n3;
        }
    }
}

