/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.config;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.config.PropertyGetter;
import org.apache.log4j.config.PropertyGetter$PropertyCallback;

public class PropertyPrinter
implements PropertyGetter$PropertyCallback {
    protected int numAppenders = 0;
    protected Hashtable appenderNames = new Hashtable();
    protected Hashtable layoutNames = new Hashtable();
    protected PrintWriter out;
    protected boolean doCapitalize;

    public PropertyPrinter(PrintWriter printWriter) {
        this(printWriter, false);
    }

    public PropertyPrinter(PrintWriter printWriter, boolean bl2) {
        this.out = printWriter;
        this.doCapitalize = bl2;
        this.print(printWriter);
        printWriter.flush();
    }

    protected String genAppName() {
        return "A" + this.numAppenders++;
    }

    protected boolean isGenAppName(String string) {
        if (string.length() < 2 || string.charAt(0) != 'A') {
            return false;
        }
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) < '0' || string.charAt(n2) > '9') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void print(PrintWriter printWriter) {
        this.printOptions(printWriter, Logger.getRootLogger());
        Enumeration enumeration = LogManager.getCurrentLoggers();
        while (enumeration.hasMoreElements()) {
            this.printOptions(printWriter, (Logger)enumeration.nextElement());
        }
    }

    protected void printOptions(PrintWriter printWriter, Logger logger) {
        Object object;
        Enumeration enumeration = logger.getAllAppenders();
        Object object2 = logger.getLevel();
        object2 = object2 == null ? "" : ((Priority)object2).toString();
        while (enumeration.hasMoreElements()) {
            object = (Appender)enumeration.nextElement();
            String string = (String)this.appenderNames.get(object);
            if (string == null) {
                string = object.getName();
                if (string == null || this.isGenAppName(string)) {
                    string = this.genAppName();
                }
                this.appenderNames.put(object, string);
                this.printOptions(printWriter, object, "log4j.appender." + string);
                if (object.getLayout() != null) {
                    this.printOptions(printWriter, object.getLayout(), "log4j.appender." + string + ".layout");
                }
            }
            object2 = (String)object2 + ", " + string;
        }
        Object object3 = object = logger == Logger.getRootLogger() ? "log4j.rootLogger" : "log4j.logger." + logger.getName();
        if (object2 != "") {
            printWriter.println((String)object + "=" + (String)object2);
        }
    }

    protected void printOptions(PrintWriter printWriter, Object object, String string) {
        printWriter.println(string + "=" + object.getClass().getName());
        PropertyGetter.getProperties(object, this, string + ".");
    }

    public void foundProperty(Object object, String string, String string2, Object object2) {
        if (object instanceof Appender && "name".equals(string2)) {
            return;
        }
        if (this.doCapitalize) {
            string2 = PropertyPrinter.capitalize(string2);
        }
        this.out.println(string + string2 + "=" + object2.toString());
    }

    public static String capitalize(String string) {
        if (Character.isLowerCase(string.charAt(0)) && (string.length() == 1 || Character.isLowerCase(string.charAt(1)))) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.setCharAt(0, Character.toUpperCase(string.charAt(0)));
            return stringBuffer.toString();
        }
        return string;
    }

    public static void main(String[] stringArray) {
        new PropertyPrinter(new PrintWriter(System.out));
    }
}

