/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.config;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.config.PropertySetterException;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.OptionHandler;

public class PropertySetter {
    protected Object obj;
    protected PropertyDescriptor[] props;
    static Class class$java$lang$String;
    static Class class$org$apache$log4j$Priority;

    public PropertySetter(Object object) {
        this.obj = object;
    }

    protected void introspect() {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.obj.getClass());
            this.props = beanInfo.getPropertyDescriptors();
            return;
        }
        catch (IntrospectionException introspectionException) {
            LogLog.error("Failed to introspect " + this.obj + ": " + introspectionException.getMessage());
            this.props = new PropertyDescriptor[0];
            return;
        }
    }

    public static void setProperties(Object object, Properties properties, String string) {
        new PropertySetter(object).setProperties(properties, string);
    }

    public void setProperties(Properties properties, String string) {
        int n2 = string.length();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string) || string2.indexOf(46, n2 + 1) > 0) continue;
            String string3 = OptionConverter.findAndSubst(string2, properties);
            if ("layout".equals(string2 = string2.substring(n2)) && this.obj instanceof Appender) continue;
            this.setProperty(string2, string3);
        }
        this.activate();
    }

    public void setProperty(String string, String string2) {
        if (string2 == null) {
            return;
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string = Introspector.decapitalize(string));
        if (propertyDescriptor == null) {
            LogLog.warn("No such property [" + string + "] in " + this.obj.getClass().getName() + ".");
            return;
        }
        try {
            this.setProperty(propertyDescriptor, string, string2);
            return;
        }
        catch (PropertySetterException propertySetterException) {
            LogLog.warn("Failed to set property [" + string + "] to value \"" + string2 + "\". ", propertySetterException.rootCause);
            return;
        }
    }

    public void setProperty(PropertyDescriptor object, String string, String object2) {
        if ((object = ((PropertyDescriptor)object).getWriteMethod()) == null) {
            throw new PropertySetterException("No setter for property [" + string + "].");
        }
        Class<?>[] classArray = ((Method)object).getParameterTypes();
        if (classArray.length != 1) {
            throw new PropertySetterException("#params for setter != 1");
        }
        try {
            object2 = this.convertArg((String)object2, classArray[0]);
        }
        catch (Throwable throwable) {
            throw new PropertySetterException("Conversion to type [" + classArray[0] + "] failed. Reason: " + throwable);
        }
        if (object2 == null) {
            throw new PropertySetterException("Conversion to type [" + classArray[0] + "] failed.");
        }
        LogLog.debug("Setting property [" + string + "] to [" + object2 + "].");
        try {
            ((Method)object).invoke(this.obj, object2);
            return;
        }
        catch (Exception exception) {
            throw new PropertySetterException(exception);
        }
    }

    protected Object convertArg(String string, Class clazz) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if ((class$java$lang$String == null ? (class$java$lang$String = PropertySetter.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz)) {
            return string;
        }
        if (Integer.TYPE.isAssignableFrom(clazz)) {
            return new Integer(string2);
        }
        if (Long.TYPE.isAssignableFrom(clazz)) {
            return new Long(string2);
        }
        if (Boolean.TYPE.isAssignableFrom(clazz)) {
            if ("true".equalsIgnoreCase(string2)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(string2)) {
                return Boolean.FALSE;
            }
        } else if ((class$org$apache$log4j$Priority == null ? (class$org$apache$log4j$Priority = PropertySetter.class$("org.apache.log4j.Priority")) : class$org$apache$log4j$Priority).isAssignableFrom(clazz)) {
            return OptionConverter.toLevel(string2, Level.DEBUG);
        }
        return null;
    }

    protected PropertyDescriptor getPropertyDescriptor(String string) {
        if (this.props == null) {
            this.introspect();
        }
        int n2 = 0;
        while (n2 < this.props.length) {
            if (string.equals(this.props[n2].getName())) {
                return this.props[n2];
            }
            ++n2;
        }
        return null;
    }

    public void activate() {
        if (this.obj instanceof OptionHandler) {
            ((OptionHandler)this.obj).activateOptions();
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

