/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.io.File;
import org.apache.log4j.helpers.LogLog;

public abstract class FileWatchdog
extends Thread {
    public static final long DEFAULT_DELAY = 60000L;
    public String filename;
    protected long delay = 60000L;
    File file;
    long lastModif = 0L;
    boolean warnedAlready = false;
    boolean interrupted = false;

    public FileWatchdog(String string) {
        this.filename = string;
        this.file = new File(string);
        this.setDaemon(true);
        this.checkAndConfigure();
    }

    public void setDelay(long l2) {
        this.delay = l2;
    }

    public abstract void doOnChange();

    protected void checkAndConfigure() {
        boolean bl2;
        try {
            bl2 = this.file.exists();
        }
        catch (SecurityException securityException) {
            LogLog.warn("Was not allowed to read check file existance, file:[" + this.filename + "].");
            this.interrupted = true;
            return;
        }
        if (bl2) {
            long l2 = this.file.lastModified();
            if (l2 > this.lastModif) {
                this.lastModif = l2;
                this.doOnChange();
                this.warnedAlready = false;
            }
            return;
        }
        if (!this.warnedAlready) {
            LogLog.debug("[" + this.filename + "] does not exist.");
            this.warnedAlready = true;
        }
    }

    public void run() {
        while (!this.interrupted) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {}
            this.checkAndConfigure();
        }
    }
}

