/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.spi.LoggerRepository;

public class OptionConverter {
    static String DELIM_START = "${";
    static char DELIM_STOP = (char)125;
    static int DELIM_START_LEN = 2;
    static int DELIM_STOP_LEN = 1;
    static Class class$java$lang$String;
    static Class class$org$apache$log4j$Level;
    static Class class$org$apache$log4j$spi$Configurator;

    private OptionConverter() {
    }

    public static String[] concatanateArrays(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public static String convertSpecialChars(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            if ((n4 = string.charAt(n3++)) == 92) {
                if ((n4 = string.charAt(n3++)) == 110) {
                    n4 = 10;
                } else if (n4 == 114) {
                    n4 = 13;
                } else if (n4 == 116) {
                    n4 = 9;
                } else if (n4 == 102) {
                    n4 = 12;
                } else if (n4 == 8) {
                    n4 = 8;
                } else if (n4 == 34) {
                    n4 = 34;
                } else if (n4 == 39) {
                    n4 = 39;
                } else if (n4 == 92) {
                    n4 = 92;
                }
            }
            stringBuffer.append((char)n4);
        }
        return stringBuffer.toString();
    }

    public static String getSystemProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (Throwable throwable) {
            LogLog.debug("Was not allowed to read system property \"" + string + "\".");
            return string2;
        }
    }

    public static Object instantiateByKey(Properties object, String string, Class clazz, Object object2) {
        if ((object = OptionConverter.findAndSubst(string, (Properties)object)) == null) {
            LogLog.error("Could not find value for key " + string);
            return object2;
        }
        return OptionConverter.instantiateByClassName(((String)object).trim(), clazz, object2);
    }

    public static boolean toBoolean(String string, boolean bl2) {
        if (string == null) {
            return bl2;
        }
        if ("true".equalsIgnoreCase(string = string.trim())) {
            return true;
        }
        if ("false".equalsIgnoreCase(string)) {
            return false;
        }
        return bl2;
    }

    public static int toInt(String string, int n2) {
        if (string != null) {
            string = string.trim();
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                LogLog.error("[" + string + "] is not in proper int form.");
                numberFormatException.printStackTrace();
            }
        }
        return n2;
    }

    public static Level toLevel(String string, Level objectArray) {
        if (string == null) {
            return objectArray;
        }
        int n2 = string.indexOf(35);
        if (n2 == -1) {
            if ("NULL".equalsIgnoreCase(string)) {
                return null;
            }
            return Level.toLevel(string, (Level)objectArray);
        }
        Object object = objectArray;
        String string2 = string.substring(n2 + 1);
        if ("NULL".equalsIgnoreCase(string = string.substring(0, n2))) {
            return null;
        }
        LogLog.debug("toLevel:class=[" + string2 + "]:pri=[" + string + "]");
        try {
            GenericDeclaration genericDeclaration = Loader.loadClass(string2);
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = OptionConverter.class$("java.lang.String")) : class$java$lang$String, class$org$apache$log4j$Level == null ? (class$org$apache$log4j$Level = OptionConverter.class$("org.apache.log4j.Level")) : class$org$apache$log4j$Level};
            genericDeclaration = ((Class)genericDeclaration).getMethod("toLevel", classArray);
            objectArray = new Object[]{string, objectArray};
            object = (Level)((Method)genericDeclaration).invoke(null, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogLog.warn("custom level class [" + string2 + "] not found.");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LogLog.warn("custom level class [" + string2 + "] does not have a constructor which takes one string parameter", noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LogLog.warn("custom level class [" + string2 + "] could not be instantiated", invocationTargetException);
        }
        catch (ClassCastException classCastException) {
            LogLog.warn("class [" + string2 + "] is not a subclass of org.apache.log4j.Level", classCastException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LogLog.warn("class [" + string2 + "] cannot be instantiated due to access restrictions", illegalAccessException);
        }
        catch (Exception exception) {
            LogLog.warn("class [" + string2 + "], level [" + string + "] conversion failed.", exception);
        }
        return object;
    }

    public static long toFileSize(String string, long l2) {
        if (string == null) {
            return l2;
        }
        String string2 = string.trim().toUpperCase();
        long l3 = 1L;
        int n2 = string2.indexOf("KB");
        if (n2 != -1) {
            l3 = 1024L;
            string2 = string2.substring(0, n2);
        } else {
            n2 = string2.indexOf("MB");
            if (n2 != -1) {
                l3 = 0x100000L;
                string2 = string2.substring(0, n2);
            } else {
                n2 = string2.indexOf("GB");
                if (n2 != -1) {
                    l3 = 0x40000000L;
                    string2 = string2.substring(0, n2);
                }
            }
        }
        if (string2 != null) {
            try {
                return Long.valueOf(string2) * l3;
            }
            catch (NumberFormatException numberFormatException) {
                LogLog.error("[" + string2 + "] is not in proper int form.");
                LogLog.error("[" + string + "] not in expected format.", numberFormatException);
            }
        }
        return l2;
    }

    public static String findAndSubst(String string, Properties properties) {
        if ((string = properties.getProperty(string)) == null) {
            return null;
        }
        try {
            return OptionConverter.substVars(string, properties);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogLog.error("Bad option value [" + string + "].", illegalArgumentException);
            return string;
        }
    }

    public static Object instantiateByClassName(String string, Class clazz, Object object) {
        if (string != null) {
            try {
                Class clazz2 = Loader.loadClass(string);
                if (!clazz.isAssignableFrom(clazz2)) {
                    LogLog.error("A \"" + string + "\" object is not assignable to a \"" + clazz.getName() + "\" variable.");
                    LogLog.error("The class \"" + clazz.getName() + "\" was loaded by ");
                    LogLog.error("[" + clazz.getClassLoader() + "] whereas object of type ");
                    LogLog.error("\"" + clazz2.getName() + "\" was loaded by [" + clazz2.getClassLoader() + "].");
                    return object;
                }
                return clazz2.newInstance();
            }
            catch (Exception exception) {
                LogLog.error("Could not instantiate class [" + string + "].", exception);
            }
        }
        return object;
    }

    public static String substVars(String string, Properties properties) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = string.indexOf(DELIM_START, n2)) == -1) {
                if (n2 == 0) {
                    return string;
                }
                stringBuffer.append(string.substring(n2, string.length()));
                return stringBuffer.toString();
            }
            stringBuffer.append(string.substring(n2, n3));
            n2 = string.indexOf(DELIM_STOP, n3);
            if (n2 == -1) {
                throw new IllegalArgumentException("\"" + string + "\" has no closing brace. Opening brace at position " + n3 + '.');
            }
            String string2 = string.substring(n3 += DELIM_START_LEN, n2);
            String string3 = OptionConverter.getSystemProperty(string2, null);
            if (string3 == null && properties != null) {
                string3 = properties.getProperty(string2);
            }
            if (string3 != null) {
                string2 = OptionConverter.substVars(string3, properties);
                stringBuffer.append(string2);
            }
            n2 += DELIM_STOP_LEN;
        }
    }

    public static void selectAndConfigure(URL uRL, String string, LoggerRepository loggerRepository) {
        Object object = uRL.getFile();
        if (string == null && object != null && ((String)object).endsWith(".xml")) {
            string = "org.apache.log4j.xml.DOMConfigurator";
        }
        if (string != null) {
            LogLog.debug("Preferred configurator class: " + string);
            object = (Configurator)OptionConverter.instantiateByClassName(string, class$org$apache$log4j$spi$Configurator == null ? (class$org$apache$log4j$spi$Configurator = OptionConverter.class$("org.apache.log4j.spi.Configurator")) : class$org$apache$log4j$spi$Configurator, null);
            if (object == null) {
                LogLog.error("Could not instantiate configurator [" + string + "].");
                return;
            }
        } else {
            object = new PropertyConfigurator();
        }
        object.doConfigure(uRL, loggerRepository);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

