/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.jmx;

import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.jmx.AbstractDynamicMBean;
import org.apache.log4j.jmx.LayoutDynamicMBean;
import org.apache.log4j.spi.OptionHandler;

public class AppenderDynamicMBean
extends AbstractDynamicMBean {
    private MBeanConstructorInfo[] dConstructors = new MBeanConstructorInfo[1];
    private Vector dAttributes = new Vector();
    private String dClassName = this.getClass().getName();
    private Hashtable dynamicProps = new Hashtable(5);
    private MBeanOperationInfo[] dOperations = new MBeanOperationInfo[2];
    private String dDescription = "This MBean acts as a management facade for log4j appenders.";
    private static Logger cat = Logger.getLogger(class$org$apache$log4j$jmx$AppenderDynamicMBean == null ? (class$org$apache$log4j$jmx$AppenderDynamicMBean = AppenderDynamicMBean.class$("org.apache.log4j.jmx.AppenderDynamicMBean")) : class$org$apache$log4j$jmx$AppenderDynamicMBean);
    private Appender appender;
    static Class class$org$apache$log4j$jmx$AppenderDynamicMBean;
    static Class class$org$apache$log4j$Priority;
    static Class class$java$lang$String;
    static Class class$org$apache$log4j$Layout;

    public AppenderDynamicMBean(Appender appender) {
        this.appender = appender;
        this.buildDynamicMBeanInfo();
    }

    private void buildDynamicMBeanInfo() {
        MBeanParameterInfo[] mBeanParameterInfoArray;
        Object[] objectArray = this.getClass().getConstructors();
        this.dConstructors[0] = new MBeanConstructorInfo("AppenderDynamicMBean(): Constructs a AppenderDynamicMBean instance", objectArray[0]);
        objectArray = Introspector.getBeanInfo(this.appender.getClass()).getPropertyDescriptors();
        int n2 = objectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Object object;
            mBeanParameterInfoArray = ((FeatureDescriptor)objectArray[n3]).getName();
            Method method = ((PropertyDescriptor)objectArray[n3]).getReadMethod();
            Method method2 = ((PropertyDescriptor)objectArray[n3]).getWriteMethod();
            if (method != null && this.isSupportedType((Class)(object = method.getReturnType()))) {
                object = ((Class)object).isAssignableFrom(class$org$apache$log4j$Priority == null ? AppenderDynamicMBean.class$("org.apache.log4j.Priority") : class$org$apache$log4j$Priority) ? "java.lang.String" : ((Class)object).getName();
                this.dAttributes.add(new MBeanAttributeInfo((String)mBeanParameterInfoArray, (String)object, "Dynamic", true, method2 != null, false));
                this.dynamicProps.put(mBeanParameterInfoArray, new ag(method, method2));
            }
            ++n3;
        }
        mBeanParameterInfoArray = new MBeanParameterInfo[]{};
        this.dOperations[0] = new MBeanOperationInfo("activateOptions", "activateOptions(): add an appender", mBeanParameterInfoArray, "void", 1);
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[1];
        mBeanParameterInfoArray = mBeanParameterInfoArray2;
        mBeanParameterInfoArray2[0] = new MBeanParameterInfo("layout class", "java.lang.String", "layout class");
        this.dOperations[1] = new MBeanOperationInfo("setLayout", "setLayout(): add a layout", mBeanParameterInfoArray, "void", 1);
    }

    private boolean isSupportedType(Class clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = AppenderDynamicMBean.class$("java.lang.String")) : class$java$lang$String)) {
            return true;
        }
        return clazz.isAssignableFrom(class$org$apache$log4j$Priority == null ? (class$org$apache$log4j$Priority = AppenderDynamicMBean.class$("org.apache.log4j.Priority")) : class$org$apache$log4j$Priority);
    }

    public MBeanInfo getMBeanInfo() {
        cat.debug("getMBeanInfo called.");
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[this.dAttributes.size()];
        this.dAttributes.toArray(mBeanAttributeInfoArray);
        return new MBeanInfo(this.dClassName, this.dDescription, mBeanAttributeInfoArray, this.dConstructors, this.dOperations, new MBeanNotificationInfo[0]);
    }

    public Object invoke(String object, Object[] objectArray, String[] stringArray) {
        if (((String)object).equals("activateOptions") && this.appender instanceof OptionHandler) {
            ((OptionHandler)((Object)this.appender)).activateOptions();
            return "Options activated.";
        }
        if (((String)object).equals("setLayout")) {
            object = (Layout)OptionConverter.instantiateByClassName((String)objectArray[0], class$org$apache$log4j$Layout == null ? (class$org$apache$log4j$Layout = AppenderDynamicMBean.class$("org.apache.log4j.Layout")) : class$org$apache$log4j$Layout, null);
            this.appender.setLayout((Layout)object);
            this.registerLayoutMBean((Layout)object);
        }
        return null;
    }

    void registerLayoutMBean(Layout object) {
        if (object == null) {
            return;
        }
        String string = this.appender.getName() + ",layout=" + object.getClass().getName();
        cat.debug("Adding LayoutMBean:" + string);
        try {
            LayoutDynamicMBean layoutDynamicMBean = new LayoutDynamicMBean((Layout)object);
            object = new ObjectName("log4j:appender=" + string);
            this.server.registerMBean(layoutDynamicMBean, (ObjectName)object);
            this.dAttributes.add(new MBeanAttributeInfo("appender=" + string, "javax.management.ObjectName", "The " + string + " layout.", true, true, false));
            return;
        }
        catch (Exception exception) {
            cat.error("Could not add DynamicLayoutMBean for [" + string + "].", exception);
            return;
        }
    }

    protected Logger getLogger() {
        return cat;
    }

    public Object getAttribute(String string) {
        ag ag2;
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this.dClassName + " with null attribute name");
        }
        cat.debug("getAttribute called with [" + string + "].");
        if (string.startsWith("appender=" + this.appender.getName() + ",layout")) {
            try {
                return new ObjectName("log4j:" + string);
            }
            catch (Exception exception) {
                cat.error("attributeName", exception);
            }
        }
        if ((ag2 = (ag)this.dynamicProps.get(string)) != null && ag2.a != null) {
            try {
                return ag2.a.invoke((Object)this.appender, null);
            }
            catch (Exception exception) {
                return null;
            }
        }
        throw new AttributeNotFoundException("Cannot find " + string + " attribute in " + this.dClassName);
    }

    public void setAttribute(Attribute object) {
        if (object == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Cannot invoke a setter of " + this.dClassName + " with null attribute");
        }
        String string = ((Attribute)object).getName();
        object = ((Attribute)object).getValue();
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke the setter of " + this.dClassName + " with null attribute name");
        }
        ag ag2 = (ag)this.dynamicProps.get(string);
        if (ag2 != null && ag2.b != null) {
            Object[] objectArray = new Object[1];
            if (ag2.b.getParameterTypes()[0] == (class$org$apache$log4j$Priority == null ? (class$org$apache$log4j$Priority = AppenderDynamicMBean.class$("org.apache.log4j.Priority")) : class$org$apache$log4j$Priority)) {
                object = OptionConverter.toLevel((String)object, (Level)this.getAttribute(string));
            }
            objectArray[0] = object;
            try {
                ag2.b.invoke((Object)this.appender, objectArray);
                return;
            }
            catch (Exception exception) {
                cat.error("FIXME", exception);
                return;
            }
        }
        if (!string.endsWith(".layout")) {
            throw new AttributeNotFoundException("Attribute " + string + " not found in " + this.getClass().getName());
        }
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) {
        cat.debug("preRegister called. Server=" + mBeanServer + ", name=" + objectName);
        this.server = mBeanServer;
        this.registerLayoutMBean(this.appender.getLayout());
        return objectName;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

