/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class StreamUtils {
    public static final int DEFAULT_BUFFER_SIZE = 2048;

    public static void copy(InputStream inputStream, OutputStream outputStream) {
        StreamUtils.copy(inputStream, outputStream, 2048);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = inputStream.read(byArray);
        while (n3 != -1) {
            outputStream.write(byArray, 0, n3);
            n3 = inputStream.read(byArray);
        }
        outputStream.flush();
    }

    public static void copyThenClose(InputStream inputStream, OutputStream outputStream) {
        StreamUtils.copy(inputStream, outputStream);
        inputStream.close();
        outputStream.close();
    }

    public static byte[] getBytes(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamUtils.copy(inputStream, byteArrayOutputStream);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }
}

