/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.LogRecord;
import org.apache.log4j.lf5.LogRecordFilter;
import org.apache.log4j.lf5.util.DateFormatManager;
import org.apache.log4j.lf5.util.LogFileParser;
import org.apache.log4j.lf5.viewer.FilteredLogTableModel;
import org.apache.log4j.lf5.viewer.LF5SwingUtils;
import org.apache.log4j.lf5.viewer.LogFactor5ErrorDialog;
import org.apache.log4j.lf5.viewer.LogFactor5InputDialog;
import org.apache.log4j.lf5.viewer.LogTable;
import org.apache.log4j.lf5.viewer.LogTableColumn;
import org.apache.log4j.lf5.viewer.TrackingAdjustmentListener;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryExplorerTree;
import org.apache.log4j.lf5.viewer.configure.ConfigurationManager;
import org.apache.log4j.lf5.viewer.configure.MRUFileManager;

public class LogBrokerMonitor {
    public static final String DETAILED_VIEW = "Detailed";
    public JFrame _logMonitorFrame;
    protected int _logMonitorFrameWidth = 550;
    protected int _logMonitorFrameHeight = 500;
    public LogTable _table;
    public CategoryExplorerTree _categoryExplorerTree;
    protected String _searchText;
    public String _NDCTextFilter = "";
    protected LogLevel _leastSevereDisplayedLogLevel = LogLevel.DEBUG;
    protected JScrollPane _logTableScrollPane;
    protected JLabel _statusLabel;
    protected Object _lock = new Object();
    protected JComboBox _fontSizeCombo;
    public int _fontSize = 10;
    public String _fontName = "Dialog";
    protected String _currentView = "Detailed";
    protected boolean _loadSystemFonts = false;
    protected boolean _trackTableScrollPane = true;
    protected Dimension _lastTableViewportSize;
    protected boolean _callSystemExitOnClose = false;
    protected List _displayedLogBrokerProperties = new Vector();
    protected Map _logLevelMenuItems = new HashMap();
    protected Map _logTableColumnMenuItems = new HashMap();
    protected List _levels = null;
    protected List _columns = null;
    protected boolean _isDisposed = false;
    protected ConfigurationManager _configurationManager = null;
    protected MRUFileManager _mruFileManager = null;
    protected File _fileLocation = null;

    public LogBrokerMonitor(List object) {
        this._levels = object;
        this._columns = LogTableColumn.getLogTableColumns();
        object = System.getProperty("monitor.exit");
        if (object == null) {
            object = "false";
        }
        if (((String)object).trim().toLowerCase().equals("true")) {
            this._callSystemExitOnClose = true;
        }
        this.initComponents();
        this._logMonitorFrame.addWindowListener(new aP(this));
    }

    public void show(int n2) {
        if (this._logMonitorFrame.isVisible()) {
            return;
        }
        SwingUtilities.invokeLater(new aj(this, n2));
    }

    public void show() {
        this.show(0);
    }

    public void dispose() {
        this._logMonitorFrame.dispose();
        this._isDisposed = true;
        if (this._callSystemExitOnClose) {
            System.exit(0);
        }
    }

    public void hide() {
        ((Component)this._logMonitorFrame).setVisible(false);
    }

    public DateFormatManager getDateFormatManager() {
        return this._table.getDateFormatManager();
    }

    public void setDateFormatManager(DateFormatManager dateFormatManager) {
        this._table.setDateFormatManager(dateFormatManager);
    }

    public boolean getCallSystemExitOnClose() {
        return this._callSystemExitOnClose;
    }

    public void setCallSystemExitOnClose(boolean bl2) {
        this._callSystemExitOnClose = bl2;
    }

    public void addMessage(LogRecord logRecord) {
        if (this._isDisposed) {
            return;
        }
        SwingUtilities.invokeLater(new au(this, logRecord));
    }

    public void setMaxNumberOfLogRecords(int n2) {
        this._table.getFilteredLogTableModel().setMaxNumberOfLogRecords(n2);
    }

    public JFrame getBaseFrame() {
        return this._logMonitorFrame;
    }

    public void setTitle(String string) {
        this._logMonitorFrame.setTitle(string + " - LogFactor5");
    }

    public void setFrameSize(int n2, int n3) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (n2 > 0 && n2 < dimension.width) {
            this._logMonitorFrameWidth = n2;
        }
        if (n3 > 0 && n3 < dimension.height) {
            this._logMonitorFrameHeight = n3;
        }
        this.updateFrameSize();
    }

    public void setFontSize(int n2) {
        this.changeFontSizeCombo(this._fontSizeCombo, n2);
    }

    public void addDisplayedProperty(Object object) {
        this._displayedLogBrokerProperties.add(object);
    }

    public Map getLogLevelMenuItems() {
        return this._logLevelMenuItems;
    }

    public Map getLogTableColumnMenuItems() {
        return this._logTableColumnMenuItems;
    }

    public JCheckBoxMenuItem getTableColumnMenuItem(LogTableColumn logTableColumn) {
        return this.getLogTableColumnMenuItem(logTableColumn);
    }

    public CategoryExplorerTree getCategoryExplorerTree() {
        return this._categoryExplorerTree;
    }

    public String getNDCTextFilter() {
        return this._NDCTextFilter;
    }

    public void setNDCLogRecordFilter(String string) {
        this._table.getFilteredLogTableModel().setLogRecordFilter(this.createNDCLogRecordFilter(string));
    }

    public void setSearchText(String string) {
        this._searchText = string;
    }

    public void setNDCTextFilter(String string) {
        if (string == null) {
            this._NDCTextFilter = "";
            return;
        }
        this._NDCTextFilter = string;
    }

    public void sortByNDC() {
        String string = this._NDCTextFilter;
        if (string == null || string.length() == 0) {
            return;
        }
        this._table.getFilteredLogTableModel().setLogRecordFilter(this.createNDCLogRecordFilter(string));
    }

    public void findSearchText() {
        String string = this._searchText;
        if (string == null || string.length() == 0) {
            return;
        }
        int n2 = this.getFirstSelectedRow();
        int n3 = this.findRecord(n2, string, this._table.getFilteredLogTableModel().getFilteredRecords());
        this.selectRow(n3);
    }

    protected int getFirstSelectedRow() {
        return this._table.getSelectionModel().getMinSelectionIndex();
    }

    protected void selectRow(int n2) {
        if (n2 == -1) {
            String string = this._searchText + " not found.";
            JOptionPane.showMessageDialog(this._logMonitorFrame, string, "Text not found", 1);
            return;
        }
        LF5SwingUtils.selectRow(n2, this._table, this._logTableScrollPane);
    }

    protected int findRecord(int n2, String string, List list) {
        n2 = n2 < 0 ? 0 : ++n2;
        int n3 = list.size();
        int n4 = n2;
        while (n4 < n3) {
            if (this.matches((LogRecord)list.get(n4), string)) {
                return n4;
            }
            ++n4;
        }
        n3 = n2;
        n2 = 0;
        while (n2 < n3) {
            if (this.matches((LogRecord)list.get(n2), string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    protected boolean matches(LogRecord object, String string) {
        String string2 = ((LogRecord)object).getMessage();
        object = ((LogRecord)object).getNDC();
        if (string2 == null && object == null || string == null) {
            return false;
        }
        return string2.toLowerCase().indexOf(string.toLowerCase()) != -1 || ((String)object).toLowerCase().indexOf(string.toLowerCase()) != -1;
    }

    protected void refresh(JTextArea jTextArea) {
        String string = jTextArea.getText();
        jTextArea.setText("");
        jTextArea.setText(string);
    }

    public void refreshDetailTextArea() {
        this.refresh(this._table._detailTextArea);
    }

    public void clearDetailTextArea() {
        this._table._detailTextArea.setText("");
    }

    protected int changeFontSizeCombo(JComboBox jComboBox, int n2) {
        int n3 = jComboBox.getItemCount();
        Object e2 = jComboBox.getItemAt(0);
        int n4 = Integer.parseInt(String.valueOf(e2));
        int n5 = 0;
        while (n5 < n3) {
            Object e3 = jComboBox.getItemAt(n5);
            int n6 = Integer.parseInt(String.valueOf(e3));
            if (n4 < n6 && n6 <= n2) {
                n4 = n6;
                e2 = e3;
            }
            ++n5;
        }
        jComboBox.setSelectedItem(e2);
        return n4;
    }

    public void setFontSizeSilently(int n2) {
        this._fontSize = n2;
        this.setFontSize(this._table._detailTextArea, n2);
        this.selectRow(0);
        this.setFontSize(this._table, n2);
    }

    protected void setFontSize(Component component, int n2) {
        Font font = component.getFont();
        Font font2 = new Font(font.getFontName(), font.getStyle(), n2);
        component.setFont(font2);
    }

    protected void updateFrameSize() {
        ((Component)this._logMonitorFrame).setSize(this._logMonitorFrameWidth, this._logMonitorFrameHeight);
        this.centerFrame(this._logMonitorFrame);
    }

    public void pause(int n2) {
        try {
            Thread.sleep(n2);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    protected void initComponents() {
        this._logMonitorFrame = new JFrame("LogFactor5");
        this._logMonitorFrame.setDefaultCloseOperation(0);
        Object object = "/org/apache/log4j/lf5/viewer/images/lf5_small_icon.gif";
        object = this.getClass().getResource((String)object);
        if (object != null) {
            ((Frame)this._logMonitorFrame).setIconImage(new ImageIcon((URL)object).getImage());
        }
        this.updateFrameSize();
        object = this.createDetailTextArea();
        JScrollPane jScrollPane = new JScrollPane((Component)object);
        this._table = new LogTable((JTextArea)object);
        this.setView(this._currentView, this._table);
        this._table.setFont(new Font(this._fontName, 0, this._fontSize));
        this._logTableScrollPane = new JScrollPane(this._table);
        if (this._trackTableScrollPane) {
            this._logTableScrollPane.getVerticalScrollBar().addAdjustmentListener(new TrackingAdjustmentListener());
        }
        object = new JSplitPane();
        ((JSplitPane)object).setOneTouchExpandable(true);
        ((JSplitPane)object).setOrientation(0);
        ((JSplitPane)object).setLeftComponent(this._logTableScrollPane);
        ((JSplitPane)object).setRightComponent(jScrollPane);
        ((JSplitPane)object).setDividerLocation(350);
        this._categoryExplorerTree = new CategoryExplorerTree();
        this._table.getFilteredLogTableModel().setLogRecordFilter(this.createLogRecordFilter());
        jScrollPane = new JScrollPane(this._categoryExplorerTree);
        jScrollPane.setPreferredSize(new Dimension(130, 400));
        this._mruFileManager = new MRUFileManager();
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setRightComponent((Component)object);
        jSplitPane.setLeftComponent(jScrollPane);
        jSplitPane.setDividerLocation(130);
        this._logMonitorFrame.getRootPane().setJMenuBar(this.createMenuBar());
        this._logMonitorFrame.getContentPane().add((Component)jSplitPane, "Center");
        this._logMonitorFrame.getContentPane().add((Component)this.createToolBar(), "North");
        this._logMonitorFrame.getContentPane().add((Component)this.createStatusArea(), "South");
        this.makeLogTableListenToCategoryExplorer();
        this.addTableModelProperties();
        this._configurationManager = new ConfigurationManager(this, this._table);
    }

    public LogRecordFilter createLogRecordFilter() {
        return new aF(this);
    }

    protected LogRecordFilter createNDCLogRecordFilter(String string) {
        this._NDCTextFilter = string;
        return new aJ(this);
    }

    public void updateStatusLabel() {
        this._statusLabel.setText(this.getRecordsDisplayedMessage());
    }

    public String getRecordsDisplayedMessage() {
        FilteredLogTableModel filteredLogTableModel = this._table.getFilteredLogTableModel();
        return this.getStatusText(filteredLogTableModel.getRowCount(), filteredLogTableModel.getTotalRowCount());
    }

    protected void addTableModelProperties() {
        FilteredLogTableModel filteredLogTableModel = this._table.getFilteredLogTableModel();
        this.addDisplayedProperty(new aK(this));
        this.addDisplayedProperty(new aL(filteredLogTableModel));
    }

    protected String getStatusText(int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Displaying: ");
        stringBuffer.append(n2);
        stringBuffer.append(" records out of a total of: ");
        stringBuffer.append(n3);
        stringBuffer.append(" records.");
        return stringBuffer.toString();
    }

    protected void makeLogTableListenToCategoryExplorer() {
        aM aM2 = new aM(this);
        this._categoryExplorerTree.getExplorerModel().addActionListener(aM2);
    }

    protected JPanel createStatusArea() {
        JLabel jLabel;
        JPanel jPanel = new JPanel();
        this._statusLabel = jLabel = new JLabel("No log records to display.");
        jLabel.setHorizontalAlignment(2);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(jLabel);
        return jPanel;
    }

    protected JTextArea createDetailTextArea() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(new Font("Monospaced", 0, 14));
        jTextArea.setTabSize(3);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(false);
        return jTextArea;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.createFileMenu());
        jMenuBar.add(this.createEditMenu());
        jMenuBar.add(this.createLogLevelMenu());
        jMenuBar.add(this.createViewMenu());
        jMenuBar.add(this.createConfigureMenu());
        jMenuBar.add(this.createHelpMenu());
        return jMenuBar;
    }

    protected JMenu createLogLevelMenu() {
        JMenu jMenu = new JMenu("Log Level");
        jMenu.setMnemonic('l');
        Iterator iterator = this.getLogLevels();
        while (iterator.hasNext()) {
            jMenu.add(this.getMenuItem((LogLevel)iterator.next()));
        }
        jMenu.addSeparator();
        jMenu.add(this.createAllLogLevelsMenuItem());
        jMenu.add(this.createNoLogLevelsMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createLogLevelColorMenu());
        jMenu.add(this.createResetLogLevelColorMenuItem());
        return jMenu;
    }

    protected JMenuItem createAllLogLevelsMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Show all LogLevels");
        jMenuItem.setMnemonic('s');
        jMenuItem.addActionListener(new aN(this));
        return jMenuItem;
    }

    protected JMenuItem createNoLogLevelsMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Hide all LogLevels");
        jMenuItem.setMnemonic('h');
        jMenuItem.addActionListener(new aO(this));
        return jMenuItem;
    }

    protected JMenu createLogLevelColorMenu() {
        JMenu jMenu = new JMenu("Configure LogLevel Colors");
        jMenu.setMnemonic('c');
        Iterator iterator = this.getLogLevels();
        while (iterator.hasNext()) {
            jMenu.add(this.createSubMenuItem((LogLevel)iterator.next()));
        }
        return jMenu;
    }

    protected JMenuItem createResetLogLevelColorMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Reset LogLevel Colors");
        jMenuItem.setMnemonic('r');
        jMenuItem.addActionListener(new ak(this));
        return jMenuItem;
    }

    public void selectAllLogLevels(boolean bl2) {
        Iterator iterator = this.getLogLevels();
        while (iterator.hasNext()) {
            this.getMenuItem((LogLevel)iterator.next()).setSelected(bl2);
        }
    }

    public JCheckBoxMenuItem getMenuItem(LogLevel logLevel) {
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this._logLevelMenuItems.get(logLevel);
        if (jCheckBoxMenuItem == null) {
            jCheckBoxMenuItem = this.createMenuItem(logLevel);
            this._logLevelMenuItems.put(logLevel, jCheckBoxMenuItem);
        }
        return jCheckBoxMenuItem;
    }

    protected JMenuItem createSubMenuItem(LogLevel logLevel) {
        JMenuItem jMenuItem = new JMenuItem(logLevel.toString());
        LogLevel logLevel2 = logLevel;
        jMenuItem.setMnemonic(logLevel.toString().charAt(0));
        jMenuItem.addActionListener(new al(this, jMenuItem, logLevel2));
        return jMenuItem;
    }

    public void showLogLevelColorChangeDialog(JMenuItem serializable, LogLevel logLevel) {
        if ((serializable = JColorChooser.showDialog(this._logMonitorFrame, "Choose LogLevel Color", serializable.getForeground())) != null) {
            logLevel.setLogLevelColorMap(logLevel, (Color)serializable);
            this._table.getFilteredLogTableModel().refresh();
        }
    }

    protected JCheckBoxMenuItem createMenuItem(LogLevel logLevel) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(logLevel.toString());
        jCheckBoxMenuItem.setSelected(true);
        jCheckBoxMenuItem.setMnemonic(logLevel.toString().charAt(0));
        jCheckBoxMenuItem.addActionListener(new am(this));
        return jCheckBoxMenuItem;
    }

    protected JMenu createViewMenu() {
        JMenu jMenu = new JMenu("View");
        jMenu.setMnemonic('v');
        Iterator iterator = this.getLogTableColumns();
        while (iterator.hasNext()) {
            jMenu.add(this.getLogTableColumnMenuItem((LogTableColumn)iterator.next()));
        }
        jMenu.addSeparator();
        jMenu.add(this.createAllLogTableColumnsMenuItem());
        jMenu.add(this.createNoLogTableColumnsMenuItem());
        return jMenu;
    }

    protected JCheckBoxMenuItem getLogTableColumnMenuItem(LogTableColumn logTableColumn) {
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this._logTableColumnMenuItems.get(logTableColumn);
        if (jCheckBoxMenuItem == null) {
            jCheckBoxMenuItem = this.createLogTableColumnMenuItem(logTableColumn);
            this._logTableColumnMenuItems.put(logTableColumn, jCheckBoxMenuItem);
        }
        return jCheckBoxMenuItem;
    }

    protected JCheckBoxMenuItem createLogTableColumnMenuItem(LogTableColumn logTableColumn) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(logTableColumn.toString());
        jCheckBoxMenuItem.setSelected(true);
        jCheckBoxMenuItem.setMnemonic(logTableColumn.toString().charAt(0));
        jCheckBoxMenuItem.addActionListener(new an(this));
        return jCheckBoxMenuItem;
    }

    public List updateView() {
        ArrayList<LogTableColumn> arrayList = new ArrayList<LogTableColumn>();
        Iterator iterator = this._columns.iterator();
        while (iterator.hasNext()) {
            LogTableColumn logTableColumn = (LogTableColumn)iterator.next();
            if (!this.getLogTableColumnMenuItem(logTableColumn).isSelected()) continue;
            arrayList.add(logTableColumn);
        }
        return arrayList;
    }

    protected JMenuItem createAllLogTableColumnsMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Show all Columns");
        jMenuItem.setMnemonic('s');
        jMenuItem.addActionListener(new ao(this));
        return jMenuItem;
    }

    protected JMenuItem createNoLogTableColumnsMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Hide all Columns");
        jMenuItem.setMnemonic('h');
        jMenuItem.addActionListener(new ap(this));
        return jMenuItem;
    }

    public void selectAllLogTableColumns(boolean bl2) {
        Iterator iterator = this.getLogTableColumns();
        while (iterator.hasNext()) {
            this.getLogTableColumnMenuItem((LogTableColumn)iterator.next()).setSelected(bl2);
        }
    }

    protected JMenu createFileMenu() {
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('f');
        jMenu.add(this.createOpenMI());
        jMenu.add(this.createOpenURLMI());
        jMenu.addSeparator();
        jMenu.add(this.createCloseMI());
        this.createMRUFileListMI(jMenu);
        jMenu.addSeparator();
        jMenu.add(this.createExitMI());
        return jMenu;
    }

    protected JMenuItem createOpenMI() {
        JMenuItem jMenuItem = new JMenuItem("Open...");
        jMenuItem.setMnemonic('o');
        jMenuItem.addActionListener(new aq(this));
        return jMenuItem;
    }

    protected JMenuItem createOpenURLMI() {
        JMenuItem jMenuItem = new JMenuItem("Open URL...");
        jMenuItem.setMnemonic('u');
        jMenuItem.addActionListener(new ar(this));
        return jMenuItem;
    }

    protected JMenuItem createCloseMI() {
        JMenuItem jMenuItem = new JMenuItem("Close");
        jMenuItem.setMnemonic('c');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control Q"));
        jMenuItem.addActionListener(new as(this));
        return jMenuItem;
    }

    protected void createMRUFileListMI(JMenu jMenu) {
        String[] stringArray = this._mruFileManager.getMRUFileList();
        if (stringArray != null) {
            jMenu.addSeparator();
            int n2 = 0;
            while (n2 < stringArray.length) {
                JMenuItem jMenuItem = new JMenuItem(n2 + 1 + " " + stringArray[n2]);
                jMenuItem.setMnemonic(n2 + 1);
                jMenuItem.addActionListener(new at(this));
                jMenu.add(jMenuItem);
                ++n2;
            }
        }
    }

    protected JMenuItem createExitMI() {
        JMenuItem jMenuItem = new JMenuItem("Exit");
        jMenuItem.setMnemonic('x');
        jMenuItem.addActionListener(new av(this));
        return jMenuItem;
    }

    protected JMenu createConfigureMenu() {
        JMenu jMenu = new JMenu("Configure");
        jMenu.setMnemonic('c');
        jMenu.add(this.createConfigureSave());
        jMenu.add(this.createConfigureReset());
        jMenu.add(this.createConfigureMaxRecords());
        return jMenu;
    }

    protected JMenuItem createConfigureSave() {
        JMenuItem jMenuItem = new JMenuItem("Save");
        jMenuItem.setMnemonic('s');
        jMenuItem.addActionListener(new aw(this));
        return jMenuItem;
    }

    protected JMenuItem createConfigureReset() {
        JMenuItem jMenuItem = new JMenuItem("Reset");
        jMenuItem.setMnemonic('r');
        jMenuItem.addActionListener(new ax(this));
        return jMenuItem;
    }

    protected JMenuItem createConfigureMaxRecords() {
        JMenuItem jMenuItem = new JMenuItem("Set Max Number of Records");
        jMenuItem.setMnemonic('m');
        jMenuItem.addActionListener(new ay(this));
        return jMenuItem;
    }

    public void saveConfiguration() {
        this._configurationManager.save();
    }

    public void resetConfiguration() {
        this._configurationManager.reset();
    }

    public void setMaxRecordConfiguration() {
        String string = new LogFactor5InputDialog(this.getBaseFrame(), "Set Max Number of Records", "", 10).getText();
        if (string != null) {
            try {
                this.setMaxNumberOfLogRecords(Integer.parseInt(string));
                return;
            }
            catch (NumberFormatException numberFormatException) {
                new LogFactor5ErrorDialog(this.getBaseFrame(), "'" + string + "' is an invalid parameter.\nPlease try again.");
                this.setMaxRecordConfiguration();
            }
        }
    }

    protected JMenu createHelpMenu() {
        JMenu jMenu = new JMenu("Help");
        jMenu.setMnemonic('h');
        jMenu.add(this.createHelpProperties());
        return jMenu;
    }

    protected JMenuItem createHelpProperties() {
        JMenuItem jMenuItem = new JMenuItem("LogFactor5 Properties");
        jMenuItem.setMnemonic('l');
        jMenuItem.addActionListener(new az(this));
        return jMenuItem;
    }

    public void showPropertiesDialog(String string) {
        JOptionPane.showMessageDialog(this._logMonitorFrame, this._displayedLogBrokerProperties.toArray(), string, -1);
    }

    protected JMenu createEditMenu() {
        JMenu jMenu = new JMenu("Edit");
        jMenu.setMnemonic('e');
        jMenu.add(this.createEditFindMI());
        jMenu.add(this.createEditFindNextMI());
        jMenu.addSeparator();
        jMenu.add(this.createEditSortNDCMI());
        jMenu.add(this.createEditRestoreAllNDCMI());
        return jMenu;
    }

    protected JMenuItem createEditFindNextMI() {
        JMenuItem jMenuItem = new JMenuItem("Find Next");
        jMenuItem.setMnemonic('n');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("F3"));
        jMenuItem.addActionListener(new aA(this));
        return jMenuItem;
    }

    protected JMenuItem createEditFindMI() {
        JMenuItem jMenuItem = new JMenuItem("Find");
        jMenuItem.setMnemonic('f');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control F"));
        jMenuItem.addActionListener(new aB(this));
        return jMenuItem;
    }

    protected JMenuItem createEditSortNDCMI() {
        JMenuItem jMenuItem = new JMenuItem("Sort by NDC");
        jMenuItem.setMnemonic('s');
        jMenuItem.addActionListener(new aC(this));
        return jMenuItem;
    }

    protected JMenuItem createEditRestoreAllNDCMI() {
        JMenuItem jMenuItem = new JMenuItem("Restore all NDCs");
        jMenuItem.setMnemonic('r');
        jMenuItem.addActionListener(new aD(this));
        return jMenuItem;
    }

    protected JToolBar createToolBar() {
        JComboBox<String> jComboBox;
        JToolBar jToolBar = new JToolBar();
        jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        this._fontSizeCombo = jComboBox = new JComboBox<String>();
        Object object = this.getClass().getClassLoader();
        if (object == null) {
            object = ClassLoader.getSystemClassLoader();
        }
        object = ((ClassLoader)object).getResource("org/apache/log4j/lf5/viewer/images/channelexplorer_new.gif");
        String[] stringArray = null;
        if (object != null) {
            stringArray = new ImageIcon((URL)object);
        }
        object = new JButton("Clear Log Table");
        if (stringArray != null) {
            ((AbstractButton)object).setIcon((Icon)stringArray);
        }
        ((JComponent)object).setToolTipText("Clear Log Table.");
        ((AbstractButton)object).addActionListener(new aE(this));
        stringArray = Toolkit.getDefaultToolkit();
        stringArray = this._loadSystemFonts ? GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames() : stringArray.getFontList();
        int n2 = 0;
        while (n2 < stringArray.length) {
            jComboBox2.addItem(stringArray[n2]);
            ++n2;
        }
        jComboBox2.setSelectedItem(this._fontName);
        jComboBox2.addActionListener(new aG(this));
        jComboBox.addItem("8");
        jComboBox.addItem("9");
        jComboBox.addItem("10");
        jComboBox.addItem("12");
        jComboBox.addItem("14");
        jComboBox.addItem("16");
        jComboBox.addItem("18");
        jComboBox.addItem("24");
        jComboBox.setSelectedItem(String.valueOf(this._fontSize));
        jComboBox.addActionListener(new aH(this));
        jToolBar.add(new JLabel(" Font: "));
        jToolBar.add(jComboBox2);
        jToolBar.add(jComboBox);
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jToolBar.add((Component)object);
        ((JComponent)object).setAlignmentY(0.5f);
        ((JComponent)object).setAlignmentX(0.5f);
        jComboBox2.setMaximumSize(jComboBox2.getPreferredSize());
        jComboBox.setMaximumSize(jComboBox.getPreferredSize());
        return jToolBar;
    }

    protected void setView(String string, LogTable logTable) {
        if (!DETAILED_VIEW.equals(string)) {
            string = string + "does not match a supported view.";
            throw new IllegalArgumentException(string);
        }
        logTable.setDetailedView();
        this._currentView = string;
    }

    protected JComboBox createLogLevelCombo() {
        JComboBox jComboBox = new JComboBox();
        Iterator iterator = this.getLogLevels();
        while (iterator.hasNext()) {
            jComboBox.addItem(iterator.next());
        }
        jComboBox.setSelectedItem(this._leastSevereDisplayedLogLevel);
        jComboBox.addActionListener(new aI(this));
        jComboBox.setMaximumSize(jComboBox.getPreferredSize());
        return jComboBox;
    }

    public void setLeastSevereDisplayedLogLevel(LogLevel logLevel) {
        if (logLevel == null || this._leastSevereDisplayedLogLevel == logLevel) {
            return;
        }
        this._leastSevereDisplayedLogLevel = logLevel;
        this._table.getFilteredLogTableModel().refresh();
        this.updateStatusLabel();
    }

    protected void trackTableScrollPane() {
    }

    protected void centerFrame(JFrame jFrame) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jFrame.getSize();
        ((Component)jFrame).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    public void requestOpen() {
        File file;
        JFileChooser jFileChooser = this._fileLocation == null ? new JFileChooser() : new JFileChooser(this._fileLocation);
        if (jFileChooser.showOpenDialog(this._logMonitorFrame) == 0 && this.loadLogFile(file = jFileChooser.getSelectedFile())) {
            this._fileLocation = jFileChooser.getSelectedFile();
            this._mruFileManager.set(file);
            this.updateMRUList();
        }
    }

    public void requestOpenURL() {
        Object object = new LogFactor5InputDialog(this.getBaseFrame(), "Open URL", "URL:").getText();
        if (object != null) {
            if (((String)object).indexOf("://") == -1) {
                object = "http://" + (String)object;
            }
            try {
                object = new URL((String)object);
                if (this.loadLogFile((URL)object)) {
                    this._mruFileManager.set((URL)object);
                    this.updateMRUList();
                }
                return;
            }
            catch (MalformedURLException malformedURLException) {
                new LogFactor5ErrorDialog(this.getBaseFrame(), "Error reading URL.");
            }
        }
    }

    protected void updateMRUList() {
        JMenu jMenu = this._logMonitorFrame.getJMenuBar().getMenu(0);
        jMenu.removeAll();
        jMenu.add(this.createOpenMI());
        jMenu.add(this.createOpenURLMI());
        jMenu.addSeparator();
        jMenu.add(this.createCloseMI());
        this.createMRUFileListMI(jMenu);
        jMenu.addSeparator();
        jMenu.add(this.createExitMI());
    }

    public void requestClose() {
        this.setCallSystemExitOnClose(false);
        this.closeAfterConfirm();
    }

    public void requestOpenMRU(ActionEvent object) {
        object = ((ActionEvent)object).getActionCommand();
        object = new StringTokenizer((String)object);
        String string = ((StringTokenizer)object).nextToken().trim();
        object = ((StringTokenizer)object).nextToken("\n");
        try {
            int n2 = Integer.parseInt(string) - 1;
            InputStream inputStream = this._mruFileManager.getInputStream(n2);
            new LogFileParser(inputStream).parse(this);
            this._mruFileManager.moveToTop(n2);
            this.updateMRUList();
            return;
        }
        catch (Exception exception) {
            new LogFactor5ErrorDialog(this.getBaseFrame(), "Unable to load file " + (String)object);
            return;
        }
    }

    public void requestExit() {
        this._mruFileManager.save();
        this.setCallSystemExitOnClose(true);
        this.closeAfterConfirm();
    }

    protected void closeAfterConfirm() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this._callSystemExitOnClose) {
            stringBuffer.append("Are you sure you want to close the logging ");
            stringBuffer.append("console?\n");
            stringBuffer.append("(Note: This will not shut down the Virtual Machine,\n");
            stringBuffer.append("or the Swing event thread.)");
        } else {
            stringBuffer.append("Are you sure you want to exit?\n");
            stringBuffer.append("This will shut down the Virtual Machine.\n");
        }
        String string = "Are you sure you want to dispose of the Logging Console?";
        if (this._callSystemExitOnClose) {
            string = "Are you sure you want to exit?";
        }
        if (JOptionPane.showConfirmDialog(this._logMonitorFrame, stringBuffer.toString(), string, 2, 3, null) == 0) {
            this.dispose();
        }
    }

    protected Iterator getLogLevels() {
        return this._levels.iterator();
    }

    protected Iterator getLogTableColumns() {
        return this._columns.iterator();
    }

    protected boolean loadLogFile(File file) {
        boolean bl2 = false;
        try {
            new LogFileParser(file).parse(this);
            bl2 = true;
        }
        catch (IOException iOException) {
            new LogFactor5ErrorDialog(this.getBaseFrame(), "Error reading " + file.getName());
        }
        return bl2;
    }

    protected boolean loadLogFile(URL uRL) {
        boolean bl2 = false;
        try {
            new LogFileParser(uRL.openStream()).parse(this);
            bl2 = true;
        }
        catch (IOException iOException) {
            new LogFactor5ErrorDialog(this.getBaseFrame(), "Error reading URL:" + uRL.getFile());
        }
        return bl2;
    }
}

