/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer;

import java.awt.Font;
import java.awt.Graphics;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.lf5.util.DateFormatManager;
import org.apache.log4j.lf5.viewer.FilteredLogTableModel;
import org.apache.log4j.lf5.viewer.LogTableColumn;
import org.apache.log4j.lf5.viewer.LogTableRowRenderer;

public class LogTable
extends JTable {
    protected int _rowHeight = 30;
    public JTextArea _detailTextArea;
    public int _numCols = 9;
    protected TableColumn[] _tableColumns = new TableColumn[this._numCols];
    protected int[] _colWidths = new int[]{40, 40, 40, 70, 70, 360, 440, 200, 60};
    public LogTableColumn[] _colNames = LogTableColumn.getLogTableColumnArray();
    public int _colDate = 0;
    public int _colThread = 1;
    protected int _colMessageNum = 2;
    public int _colLevel = 3;
    public int _colNDC = 4;
    protected int _colCategory = 5;
    public int _colMessage = 6;
    protected int _colLocation = 7;
    protected int _colThrown = 8;
    protected DateFormatManager _dateFormatManager = null;

    public LogTable(JTextArea object) {
        this.init();
        this._detailTextArea = object;
        this.setModel(new FilteredLogTableModel());
        object = this.getColumnModel().getColumns();
        int n2 = 0;
        while (object.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)object.nextElement();
            tableColumn.setCellRenderer(new LogTableRowRenderer());
            tableColumn.setPreferredWidth(this._colWidths[n2]);
            this._tableColumns[n2] = tableColumn;
            ++n2;
        }
        this.getSelectionModel().addListSelectionListener(new aU(this, this));
    }

    public DateFormatManager getDateFormatManager() {
        return this._dateFormatManager;
    }

    public void setDateFormatManager(DateFormatManager dateFormatManager) {
        this._dateFormatManager = dateFormatManager;
    }

    public synchronized void clearLogRecords() {
        this.getFilteredLogTableModel().clear();
    }

    public FilteredLogTableModel getFilteredLogTableModel() {
        return (FilteredLogTableModel)this.getModel();
    }

    public void setDetailedView() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n2 = 0;
        while (n2 < this._numCols) {
            tableColumnModel.removeColumn(this._tableColumns[n2]);
            ++n2;
        }
        n2 = 0;
        while (n2 < this._numCols) {
            tableColumnModel.addColumn(this._tableColumns[n2]);
            ++n2;
        }
        this.sizeColumnsToFit(-1);
    }

    public void setView(List object) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n2 = 0;
        while (n2 < this._numCols) {
            tableColumnModel.removeColumn(this._tableColumns[n2]);
            ++n2;
        }
        object = object.iterator();
        Vector vector = this.getColumnNameAndNumber();
        while (object.hasNext()) {
            tableColumnModel.addColumn(this._tableColumns[vector.indexOf(object.next())]);
        }
        this.sizeColumnsToFit(-1);
    }

    public void setFont(Font font) {
        super.setFont(font);
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            int n2 = graphics.getFontMetrics(font).getHeight();
            this._rowHeight = n2 + n2 / 3;
            this.setRowHeight(this._rowHeight);
        }
    }

    protected void init() {
        this.setRowHeight(this._rowHeight);
        this.setSelectionMode(0);
    }

    protected Vector getColumnNameAndNumber() {
        Vector<LogTableColumn> vector = new Vector<LogTableColumn>();
        int n2 = 0;
        while (n2 < this._colNames.length) {
            vector.add(n2, this._colNames[n2]);
            ++n2;
        }
        return vector;
    }
}

