/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer.categoryexplorer;

import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.lf5.LogRecord;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryElement;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNode;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryPath;

public class CategoryExplorerModel
extends DefaultTreeModel {
    protected boolean _renderFatal = true;
    protected ActionListener _listener = null;
    protected ActionEvent _event = new ActionEvent(this, 1001, "Nodes Selection changed");

    public CategoryExplorerModel(CategoryNode categoryNode) {
        super(categoryNode);
    }

    public void addLogRecord(LogRecord treeNodeArray) {
        Object object = new CategoryPath(treeNodeArray.getCategory());
        this.addCategory((CategoryPath)object);
        object = this.getCategoryNode((CategoryPath)object);
        ((CategoryNode)object).addRecord();
        if (this._renderFatal && treeNodeArray.isFatal()) {
            treeNodeArray = this.getPathToRoot((TreeNode)object);
            int n2 = treeNodeArray.length;
            int n3 = 1;
            while (n3 < n2 - 1) {
                CategoryNode categoryNode = (CategoryNode)treeNodeArray[n3];
                categoryNode.setHasFatalChildren(true);
                this.nodeChanged(categoryNode);
                ++n3;
            }
            ((CategoryNode)object).setHasFatalRecords(true);
            this.nodeChanged((TreeNode)object);
        }
    }

    public CategoryNode getRootCategoryNode() {
        return (CategoryNode)this.getRoot();
    }

    public CategoryNode getCategoryNode(String object) {
        object = new CategoryPath((String)object);
        return this.getCategoryNode((CategoryPath)object);
    }

    public CategoryNode getCategoryNode(CategoryPath categoryPath) {
        CategoryNode categoryNode = (CategoryNode)this.getRoot();
        int n2 = 0;
        while (n2 < categoryPath.size()) {
            CategoryElement categoryElement = categoryPath.categoryElementAt(n2);
            Enumeration<TreeNode> enumeration = categoryNode.children();
            boolean bl2 = false;
            while (enumeration.hasMoreElements()) {
                String string;
                CategoryNode categoryNode2 = (CategoryNode)enumeration.nextElement();
                String string2 = categoryNode2.getTitle().toLowerCase();
                if (!string2.equals(string = categoryElement.getTitle().toLowerCase())) continue;
                bl2 = true;
                categoryNode = categoryNode2;
                break;
            }
            if (!bl2) {
                return null;
            }
            ++n2;
        }
        return categoryNode;
    }

    public boolean isCategoryPathActive(CategoryPath categoryPath) {
        CategoryNode categoryNode = (CategoryNode)this.getRoot();
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < categoryPath.size()) {
            CategoryElement categoryElement = categoryPath.categoryElementAt(n2);
            Enumeration<TreeNode> enumeration = categoryNode.children();
            boolean bl3 = false;
            bl2 = false;
            while (enumeration.hasMoreElements()) {
                String string;
                CategoryNode categoryNode2 = (CategoryNode)enumeration.nextElement();
                String string2 = categoryNode2.getTitle().toLowerCase();
                if (!string2.equals(string = categoryElement.getTitle().toLowerCase())) continue;
                bl3 = true;
                categoryNode = categoryNode2;
                if (!categoryNode.isSelected()) break;
                bl2 = true;
                break;
            }
            if (!bl2 || !bl3) {
                return false;
            }
            ++n2;
        }
        return bl2;
    }

    public CategoryNode addCategory(CategoryPath categoryPath) {
        CategoryNode categoryNode = (CategoryNode)this.getRoot();
        int n2 = 0;
        while (n2 < categoryPath.size()) {
            CategoryNode categoryNode2;
            CategoryElement categoryElement = categoryPath.categoryElementAt(n2);
            Enumeration<TreeNode> enumeration = categoryNode.children();
            boolean bl2 = false;
            while (enumeration.hasMoreElements()) {
                String string;
                categoryNode2 = (CategoryNode)enumeration.nextElement();
                String string2 = categoryNode2.getTitle().toLowerCase();
                if (!string2.equals(string = categoryElement.getTitle().toLowerCase())) continue;
                bl2 = true;
                categoryNode = categoryNode2;
                break;
            }
            if (!bl2) {
                categoryNode2 = new CategoryNode(categoryElement.getTitle());
                this.insertNodeInto(categoryNode2, categoryNode, categoryNode.getChildCount());
                this.refresh(categoryNode2);
                categoryNode = categoryNode2;
            }
            ++n2;
        }
        return categoryNode;
    }

    public void update(CategoryNode categoryNode, boolean bl2) {
        if (categoryNode.isSelected() == bl2) {
            return;
        }
        if (bl2) {
            this.setParentSelection(categoryNode, true);
            return;
        }
        this.setDescendantSelection(categoryNode, false);
    }

    public void setDescendantSelection(CategoryNode object, boolean bl2) {
        object = ((DefaultMutableTreeNode)object).depthFirstEnumeration();
        while (object.hasMoreElements()) {
            CategoryNode categoryNode = (CategoryNode)object.nextElement();
            if (categoryNode.isSelected() == bl2) continue;
            categoryNode.setSelected(bl2);
            this.nodeChanged(categoryNode);
        }
        this.notifyActionListeners();
    }

    public void setParentSelection(CategoryNode treeNodeArray, boolean bl2) {
        treeNodeArray = this.getPathToRoot((TreeNode)treeNodeArray);
        int n2 = treeNodeArray.length;
        int n3 = 1;
        while (n3 < n2) {
            CategoryNode categoryNode = (CategoryNode)treeNodeArray[n3];
            if (categoryNode.isSelected() != bl2) {
                categoryNode.setSelected(bl2);
                this.nodeChanged(categoryNode);
            }
            ++n3;
        }
        this.notifyActionListeners();
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this._listener = AWTEventMulticaster.add(this._listener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this._listener = AWTEventMulticaster.remove(this._listener, actionListener);
    }

    public void resetAllNodeCounts() {
        Enumeration<TreeNode> enumeration = this.getRootCategoryNode().depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            CategoryNode categoryNode = (CategoryNode)enumeration.nextElement();
            categoryNode.resetNumberOfContainedRecords();
            this.nodeChanged(categoryNode);
        }
    }

    public TreePath getTreePathToRoot(CategoryNode categoryNode) {
        if (categoryNode == null) {
            return null;
        }
        return new TreePath(this.getPathToRoot(categoryNode));
    }

    protected void notifyActionListeners() {
        if (this._listener != null) {
            this._listener.actionPerformed(this._event);
        }
    }

    protected void refresh(CategoryNode categoryNode) {
        SwingUtilities.invokeLater(new aV(this, categoryNode));
    }
}

