/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer.categoryexplorer;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryAbstractCellEditor;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryExplorerModel;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNode;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNodeEditorRenderer;

public class CategoryNodeEditor
extends CategoryAbstractCellEditor {
    protected CategoryNodeEditorRenderer _renderer = new CategoryNodeEditorRenderer();
    public CategoryNode _lastEditedNode;
    public JCheckBox _checkBox = this._renderer.getCheckBox();
    public CategoryExplorerModel _categoryModel;
    protected JTree _tree;

    public CategoryNodeEditor(CategoryExplorerModel categoryExplorerModel) {
        this._categoryModel = categoryExplorerModel;
        this._checkBox.addActionListener(new aX(this));
        this._renderer.addMouseListener(new aY(this));
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2) {
        this._lastEditedNode = (CategoryNode)object;
        this._tree = jTree;
        return this._renderer.getTreeCellRendererComponent(jTree, object, bl2, bl3, bl4, n2, true);
    }

    public Object getCellEditorValue() {
        return this._lastEditedNode.getUserObject();
    }

    protected JMenuItem createPropertiesMenuItem(CategoryNode categoryNode) {
        JMenuItem jMenuItem = new JMenuItem("Properties");
        jMenuItem.addActionListener(new aZ(this, categoryNode));
        return jMenuItem;
    }

    public void showPropertiesDialog(CategoryNode categoryNode) {
        JOptionPane.showMessageDialog(this._tree, this.getDisplayedProperties(categoryNode), "Category Properties: " + categoryNode.getTitle(), -1);
    }

    protected Object getDisplayedProperties(CategoryNode categoryNode) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Category: " + categoryNode.getTitle());
        if (categoryNode.hasFatalRecords()) {
            arrayList.add("Contains at least one fatal LogRecord.");
        }
        if (categoryNode.hasFatalChildren()) {
            arrayList.add("Contains descendants with a fatal LogRecord.");
        }
        arrayList.add("LogRecords in this category alone: " + categoryNode.getNumberOfContainedRecords());
        arrayList.add("LogRecords in descendant categories: " + categoryNode.getNumberOfRecordsFromChildren());
        arrayList.add("LogRecords in this category including descendants: " + categoryNode.getTotalNumberOfRecords());
        return arrayList.toArray();
    }

    public void showPopup(CategoryNode categoryNode, int n2, int n3) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.setSize(150, 400);
        if (categoryNode.getParent() == null) {
            jPopupMenu.add(this.createRemoveMenuItem());
            jPopupMenu.addSeparator();
        }
        jPopupMenu.add(this.createSelectDescendantsMenuItem(categoryNode));
        jPopupMenu.add(this.createUnselectDescendantsMenuItem(categoryNode));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.createExpandMenuItem(categoryNode));
        jPopupMenu.add(this.createCollapseMenuItem(categoryNode));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.createPropertiesMenuItem(categoryNode));
        jPopupMenu.show(this._renderer, n2, n3);
    }

    protected JMenuItem createSelectDescendantsMenuItem(CategoryNode categoryNode) {
        JMenuItem jMenuItem = new JMenuItem("Select All Descendant Categories");
        jMenuItem.addActionListener(new ba(this, categoryNode));
        return jMenuItem;
    }

    protected JMenuItem createUnselectDescendantsMenuItem(CategoryNode categoryNode) {
        JMenuItem jMenuItem = new JMenuItem("Deselect All Descendant Categories");
        jMenuItem.addActionListener(new bb(this, categoryNode));
        return jMenuItem;
    }

    protected JMenuItem createExpandMenuItem(CategoryNode categoryNode) {
        JMenuItem jMenuItem = new JMenuItem("Expand All Descendant Categories");
        jMenuItem.addActionListener(new bc(this, categoryNode));
        return jMenuItem;
    }

    protected JMenuItem createCollapseMenuItem(CategoryNode categoryNode) {
        JMenuItem jMenuItem = new JMenuItem("Collapse All Descendant Categories");
        jMenuItem.addActionListener(new bd(this, categoryNode));
        return jMenuItem;
    }

    protected JMenuItem createRemoveMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Remove All Empty Categories");
        jMenuItem.addActionListener(new be(this));
        return jMenuItem;
    }

    public void expandDescendants(CategoryNode object) {
        object = ((DefaultMutableTreeNode)object).depthFirstEnumeration();
        while (object.hasMoreElements()) {
            CategoryNode categoryNode = (CategoryNode)object.nextElement();
            this.expand(categoryNode);
        }
    }

    public void collapseDescendants(CategoryNode object) {
        object = ((DefaultMutableTreeNode)object).depthFirstEnumeration();
        while (object.hasMoreElements()) {
            CategoryNode categoryNode = (CategoryNode)object.nextElement();
            this.collapse(categoryNode);
        }
    }

    public int removeUnusedNodes() {
        int n2 = 0;
        Enumeration<TreeNode> enumeration = this._categoryModel.getRootCategoryNode().depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            CategoryNode categoryNode = (CategoryNode)enumeration.nextElement();
            if (!categoryNode.isLeaf() || categoryNode.getNumberOfContainedRecords() != 0 || categoryNode.getParent() == null) continue;
            this._categoryModel.removeNodeFromParent(categoryNode);
            ++n2;
        }
        return n2;
    }

    protected void expand(CategoryNode categoryNode) {
        this._tree.expandPath(this.getTreePath(categoryNode));
    }

    protected TreePath getTreePath(CategoryNode categoryNode) {
        return new TreePath(categoryNode.getPath());
    }

    protected void collapse(CategoryNode categoryNode) {
        this._tree.collapsePath(this.getTreePath(categoryNode));
    }
}

