/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer.configure;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;

public class MRUFileManager {
    private static final String CONFIG_FILE_NAME = "mru_file_manager";
    private static final int DEFAULT_MAX_SIZE = 3;
    private int _maxSize = 0;
    private LinkedList _mruFileList;

    public MRUFileManager() {
        this.load();
        this.setMaxSize(3);
    }

    public MRUFileManager(int n2) {
        this.load();
        this.setMaxSize(n2);
    }

    public void save() {
        Object object = new File(this.getFilename());
        try {
            object = new ObjectOutputStream(new FileOutputStream((File)object));
            ((ObjectOutputStream)object).writeObject(this._mruFileList);
            ((ObjectOutputStream)object).flush();
            ((ObjectOutputStream)object).close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public int size() {
        return this._mruFileList.size();
    }

    public Object getFile(int n2) {
        if (n2 < this.size()) {
            return this._mruFileList.get(n2);
        }
        return null;
    }

    public InputStream getInputStream(int n2) {
        if (n2 < this.size()) {
            Object object = this.getFile(n2);
            if (object instanceof File) {
                return this.getInputStream((File)object);
            }
            return this.getInputStream((URL)object);
        }
        return null;
    }

    public void set(File file) {
        this.setMRU(file);
    }

    public void set(URL uRL) {
        this.setMRU(uRL);
    }

    public String[] getMRUFileList() {
        if (this.size() == 0) {
            return null;
        }
        String[] stringArray = new String[this.size()];
        int n2 = 0;
        while (n2 < this.size()) {
            Object object = this.getFile(n2);
            stringArray[n2] = object instanceof File ? ((File)object).getAbsolutePath() : object.toString();
            ++n2;
        }
        return stringArray;
    }

    public void moveToTop(int n2) {
        this._mruFileList.add(0, this._mruFileList.remove(n2));
    }

    public static void createConfigurationDirectory() {
        Object object = System.getProperty("user.home");
        String string = System.getProperty("file.separator");
        if (!((File)(object = new File((String)object + string + "lf5"))).exists()) {
            try {
                ((File)object).mkdir();
                return;
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
        }
    }

    protected InputStream getInputStream(File file) {
        return new BufferedInputStream(new FileInputStream(file));
    }

    protected InputStream getInputStream(URL uRL) {
        return uRL.openStream();
    }

    protected void setMRU(Object object) {
        int n2 = this._mruFileList.indexOf(object);
        if (n2 == -1) {
            this._mruFileList.add(0, object);
            this.setMaxSize(this._maxSize);
            return;
        }
        this.moveToTop(n2);
    }

    protected void load() {
        MRUFileManager.createConfigurationDirectory();
        Iterator iterator = new File(this.getFilename());
        if (((File)((Object)iterator)).exists()) {
            try {
                iterator = new ObjectInputStream(new FileInputStream((File)((Object)iterator)));
                this._mruFileList = (LinkedList)((ObjectInputStream)((Object)iterator)).readObject();
                ((ObjectInputStream)((Object)iterator)).close();
                iterator = this._mruFileList.iterator();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    if (e2 instanceof File || e2 instanceof URL) continue;
                    iterator.remove();
                }
                return;
            }
            catch (Exception exception) {
                this._mruFileList = new LinkedList();
                return;
            }
        }
        this._mruFileList = new LinkedList();
    }

    protected String getFilename() {
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("file.separator");
        return string + string2 + "lf5" + string2 + CONFIG_FILE_NAME;
    }

    protected void setMaxSize(int n2) {
        if (n2 < this._mruFileList.size()) {
            int n3 = 0;
            while (n3 < this._mruFileList.size() - n2) {
                this._mruFileList.removeLast();
                ++n3;
            }
        }
        this._maxSize = n2;
    }
}

