/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class SocketAppender
extends AppenderSkeleton {
    static final int DEFAULT_PORT = 4560;
    static final int DEFAULT_RECONNECTION_DELAY = 30000;
    String remoteHost;
    public InetAddress address;
    public int port = 4560;
    public ObjectOutputStream oos;
    public int reconnectionDelay = 30000;
    boolean locationInfo = false;
    private bg connector;
    int counter = 0;
    private static final int RESET_FREQUENCY = 1;

    public SocketAppender() {
    }

    public SocketAppender(InetAddress inetAddress, int n2) {
        this.address = inetAddress;
        this.remoteHost = inetAddress.getHostName();
        this.port = n2;
        this.connect(inetAddress, n2);
    }

    public SocketAppender(String string, int n2) {
        this.port = n2;
        this.address = SocketAppender.getAddressByName(string);
        this.remoteHost = string;
        this.connect(this.address, n2);
    }

    public void activateOptions() {
        this.connect(this.address, this.port);
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.cleanUp();
    }

    public void cleanUp() {
        if (this.oos != null) {
            try {
                this.oos.close();
            }
            catch (IOException iOException) {
                LogLog.error("Could not close oos.", iOException);
            }
            this.oos = null;
        }
        if (this.connector != null) {
            this.connector.a = true;
            this.connector = null;
        }
    }

    void connect(InetAddress object, int n2) {
        if (this.address == null) {
            return;
        }
        try {
            this.cleanUp();
            this.oos = new ObjectOutputStream(new Socket((InetAddress)object, n2).getOutputStream());
            return;
        }
        catch (IOException iOException) {
            object = "Could not connect to remote log4j server at [" + ((InetAddress)object).getHostName() + "].";
            if (this.reconnectionDelay > 0) {
                object = (String)object + " We will try again later.";
                this.fireConnector();
            }
            LogLog.error((String)object, iOException);
            return;
        }
    }

    public void append(LoggingEvent loggingEvent) {
        block7: {
            if (loggingEvent == null) {
                return;
            }
            if (this.address == null) {
                this.errorHandler.error("No remote host is set for SocketAppender named \"" + this.name + "\".");
                return;
            }
            if (this.oos != null) {
                try {
                    if (this.locationInfo) {
                        loggingEvent.getLocationInformation();
                    }
                    this.oos.writeObject(loggingEvent);
                    this.oos.flush();
                    if (++this.counter > 0) {
                        this.counter = 0;
                        this.oos.reset();
                    }
                    return;
                }
                catch (IOException iOException) {
                    this.oos = null;
                    LogLog.warn("Detected problem with connection: " + iOException);
                    if (this.reconnectionDelay <= 0) break block7;
                    this.fireConnector();
                }
            }
        }
    }

    void fireConnector() {
        if (this.connector == null) {
            LogLog.debug("Starting a new connector thread.");
            this.connector = new bg(this);
            this.connector.setDaemon(true);
            this.connector.setPriority(1);
            this.connector.start();
        }
    }

    static InetAddress getAddressByName(String string) {
        try {
            return InetAddress.getByName(string);
        }
        catch (Exception exception) {
            LogLog.error("Could not find address of [" + string + "].", exception);
            return null;
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setRemoteHost(String string) {
        this.address = SocketAppender.getAddressByName(string);
        this.remoteHost = string;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setPort(int n2) {
        this.port = n2;
    }

    public int getPort() {
        return this.port;
    }

    public void setLocationInfo(boolean bl2) {
        this.locationInfo = bl2;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setReconnectionDelay(int n2) {
        this.reconnectionDelay = n2;
    }

    public int getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public static bg access$002(SocketAppender socketAppender, bg bg2) {
        socketAppender.connector = bg2;
        return socketAppender.connector;
    }
}

