/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.File;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.net.SocketNode;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RootLogger;

public class SocketServer {
    static String GENERIC = "generic";
    static String CONFIG_FILE_EXT = ".lcf";
    static Logger cat = Logger.getLogger(class$org$apache$log4j$net$SocketServer == null ? (class$org$apache$log4j$net$SocketServer = SocketServer.class$("org.apache.log4j.net.SocketServer")) : class$org$apache$log4j$net$SocketServer);
    static SocketServer server;
    static int port;
    Hashtable hierarchyMap;
    LoggerRepository genericHierarchy;
    File dir;
    static Class class$org$apache$log4j$net$SocketServer;

    public static void main(String[] object) {
        if (((String[])object).length == 3) {
            SocketServer.init(object[0], object[1], object[2]);
        } else {
            SocketServer.usage("Wrong number of arguments.");
        }
        try {
            cat.info("Listening on port " + port);
            object = new ServerSocket(port);
            while (true) {
                cat.info("Waiting to accept a new client.");
                Socket socket = ((ServerSocket)object).accept();
                InetAddress inetAddress = socket.getInetAddress();
                cat.info("Connected to client at " + inetAddress);
                LoggerRepository loggerRepository = (LoggerRepository)SocketServer.server.hierarchyMap.get(inetAddress);
                if (loggerRepository == null) {
                    loggerRepository = server.configureHierarchy(inetAddress);
                }
                cat.info("Starting new socket node.");
                new Thread(new SocketNode(socket, loggerRepository)).start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    static void usage(String string) {
        System.err.println(string);
        System.err.println("Usage: java " + (class$org$apache$log4j$net$SocketServer == null ? (class$org$apache$log4j$net$SocketServer = SocketServer.class$("org.apache.log4j.net.SocketServer")) : class$org$apache$log4j$net$SocketServer).getName() + " port configFile directory");
        System.exit(1);
    }

    static void init(String object, String string, String string2) {
        try {
            port = Integer.parseInt((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            SocketServer.usage("Could not interpret port number [" + (String)object + "].");
        }
        PropertyConfigurator.configure(string);
        object = new File(string2);
        if (!((File)object).isDirectory()) {
            SocketServer.usage("[" + string2 + "] is not a directory.");
        }
        server = new SocketServer((File)object);
    }

    public SocketServer(File file) {
        this.dir = file;
        this.hierarchyMap = new Hashtable(11);
    }

    LoggerRepository configureHierarchy(InetAddress inetAddress) {
        cat.info("Locating configuration file for " + inetAddress);
        Object object = inetAddress.toString();
        int n2 = ((String)object).indexOf("/");
        if (n2 == -1) {
            cat.warn("Could not parse the inetAddress [" + inetAddress + "]. Using default hierarchy.");
            return this.genericHierarchy();
        }
        object = ((String)object).substring(0, n2);
        if (((File)(object = new File(this.dir, (String)object + CONFIG_FILE_EXT))).exists()) {
            Hierarchy hierarchy = new Hierarchy(new RootLogger((Level)Priority.DEBUG));
            this.hierarchyMap.put(inetAddress, hierarchy);
            new PropertyConfigurator().doConfigure(((File)object).getAbsolutePath(), (LoggerRepository)hierarchy);
            return hierarchy;
        }
        cat.warn("Could not find config file [" + object + "].");
        return this.genericHierarchy();
    }

    LoggerRepository genericHierarchy() {
        if (this.genericHierarchy == null) {
            File file = new File(this.dir, GENERIC + CONFIG_FILE_EXT);
            if (file.exists()) {
                this.genericHierarchy = new Hierarchy(new RootLogger((Level)Priority.DEBUG));
                new PropertyConfigurator().doConfigure(file.getAbsolutePath(), this.genericHierarchy);
            } else {
                cat.warn("Could not find config file [" + file + "]. Will use the default hierarchy.");
                this.genericHierarchy = LogManager.getLoggerRepository();
            }
        }
        return this.genericHierarchy;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

